/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.lucene.search.Collector;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.List;
import org.elasticsearch.search.aggregations.AggregationExecutionException;
import org.elasticsearch.search.aggregations.AggregationInitializationException;
import org.elasticsearch.search.aggregations.Aggregator;
import org.elasticsearch.search.aggregations.BucketCollector;
import org.elasticsearch.search.aggregations.InternalAggregation;
import org.elasticsearch.search.aggregations.InternalAggregations;
import org.elasticsearch.search.aggregations.MultiBucketCollector;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.search.profile.query.InternalProfileCollector;

public class AggregationPhase {
    @Inject
    public AggregationPhase() {
    }

    public void preProcess(SearchContext context) {
        BucketCollector bucketCollector;
        if (context.aggregations() == null) {
            return;
        }
        try {
            context.aggregations().aggregators(context.aggregations().factories().createTopLevelAggregators());
            bucketCollector = MultiBucketCollector.wrap(true, List.of(context.aggregations().aggregators()));
            bucketCollector.preCollection();
        }
        catch (IOException e) {
            throw new AggregationInitializationException("Could not initialize aggregators", e);
        }
        Collector collector = context.getProfilers() == null ? bucketCollector : new InternalProfileCollector(bucketCollector, "aggregation", List.of());
        context.queryCollectors().put(AggregationPhase.class, collector);
    }

    public void execute(SearchContext context) {
        if (context.aggregations() == null) {
            context.queryResult().aggregations(null);
            return;
        }
        if (context.queryResult().hasAggs()) {
            return;
        }
        Aggregator[] aggregators = context.aggregations().aggregators();
        ArrayList<InternalAggregation> aggregations = new ArrayList<InternalAggregation>(aggregators.length);
        if (context.aggregations().factories().context() != null) {
            context.aggregations().factories().context().multiBucketConsumer().reset();
        }
        for (Aggregator aggregator : context.aggregations().aggregators()) {
            try {
                aggregator.postCollection();
                aggregations.add(aggregator.buildTopLevel());
            }
            catch (IOException e) {
                throw new AggregationExecutionException("Failed to build aggregation [" + aggregator.name() + "]", e);
            }
        }
        context.queryResult().aggregations(new InternalAggregations(aggregations, context.request().source().aggregations()::buildPipelineTree));
        context.aggregations(null);
        context.queryCollectors().remove(AggregationPhase.class);
    }
}

