/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.runtime;

import com.carrotsearch.hppc.LongSet;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.index.LeafReaderContext;
import org.elasticsearch.script.AbstractLongFieldScript;
import org.elasticsearch.script.Script;
import org.elasticsearch.search.runtime.AbstractLongScriptFieldQuery;

public class LongScriptFieldTermsQuery
extends AbstractLongScriptFieldQuery {
    private final LongSet terms;

    public LongScriptFieldTermsQuery(Script script, Function<LeafReaderContext, AbstractLongFieldScript> leafFactory, String fieldName, LongSet terms) {
        super(script, leafFactory, fieldName);
        this.terms = terms;
    }

    @Override
    protected boolean matches(long[] values, int count) {
        for (int i = 0; i < count; ++i) {
            if (!this.terms.contains(values[i])) continue;
            return true;
        }
        return false;
    }

    @Override
    public final String toString(String field) {
        if (this.fieldName().contentEquals(field)) {
            return this.terms.toString();
        }
        return this.fieldName() + ":" + this.terms;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.terms);
    }

    @Override
    public boolean equals(Object obj) {
        if (!super.equals(obj)) {
            return false;
        }
        LongScriptFieldTermsQuery other = (LongScriptFieldTermsQuery)obj;
        return this.terms.equals(other.terms);
    }

    LongSet terms() {
        return this.terms;
    }
}

