/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.channels.ClosedChannelException;
import java.util.ArrayDeque;
import java.util.Queue;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.bytes.ReleasableBytesReference;
import org.elasticsearch.common.util.PageCacheRecycler;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.Releasables;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.InboundPipeline;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.transport.netty4.Netty4TcpChannel;
import org.elasticsearch.transport.netty4.Netty4Transport;
import org.elasticsearch.transport.netty4.Netty4Utils;

final class Netty4MessageChannelHandler
extends ChannelDuplexHandler {
    private final Netty4Transport transport;
    private final Queue<WriteOperation> queuedWrites = new ArrayDeque<WriteOperation>();
    private WriteOperation currentWrite;
    private final InboundPipeline pipeline;

    Netty4MessageChannelHandler(PageCacheRecycler recycler, Netty4Transport transport) {
        this.transport = transport;
        ThreadPool threadPool = transport.getThreadPool();
        Transport.RequestHandlers requestHandlers = transport.getRequestHandlers();
        this.pipeline = new InboundPipeline(transport.getVersion(), transport.getStatsTracker(), recycler, threadPool::relativeTimeInMillis, transport.getInflightBreaker(), requestHandlers::getHandler, transport::inboundMessage);
    }

    @Override
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        assert (Transports.assertDefaultThreadContext(this.transport.getThreadPool().getThreadContext()));
        assert (Transports.assertTransportThread());
        assert (msg instanceof ByteBuf) : "Expected message type ByteBuf, found: " + msg.getClass();
        ByteBuf buffer = (ByteBuf)msg;
        Netty4TcpChannel channel = ctx.channel().attr(Netty4Transport.CHANNEL_KEY).get();
        BytesReference wrapped = Netty4Utils.toBytesReference(buffer);
        try (ReleasableBytesReference reference = new ReleasableBytesReference(wrapped, buffer::release);){
            this.pipeline.handleBytes(channel, reference);
        }
    }

    @Override
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        assert (Transports.assertDefaultThreadContext(this.transport.getThreadPool().getThreadContext()));
        ExceptionsHelper.maybeDieOnAnotherThread(cause);
        Throwable unwrapped = ExceptionsHelper.unwrap(cause, ElasticsearchException.class);
        Throwable newCause = unwrapped != null ? unwrapped : cause;
        Netty4TcpChannel tcpChannel = ctx.channel().attr(Netty4Transport.CHANNEL_KEY).get();
        if (newCause instanceof Error) {
            this.transport.onException(tcpChannel, new Exception(newCause));
        } else {
            this.transport.onException(tcpChannel, (Exception)newCause);
        }
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        assert (msg instanceof ByteBuf);
        assert (Transports.assertDefaultThreadContext(this.transport.getThreadPool().getThreadContext()));
        boolean queued = this.queuedWrites.offer(new WriteOperation((ByteBuf)msg, promise));
        assert (queued);
        assert (Transports.assertDefaultThreadContext(this.transport.getThreadPool().getThreadContext()));
    }

    @Override
    public void channelWritabilityChanged(ChannelHandlerContext ctx) {
        assert (Transports.assertDefaultThreadContext(this.transport.getThreadPool().getThreadContext()));
        if (ctx.channel().isWritable()) {
            this.doFlush(ctx);
        }
        ctx.fireChannelWritabilityChanged();
    }

    @Override
    public void flush(ChannelHandlerContext ctx) {
        assert (Transports.assertDefaultThreadContext(this.transport.getThreadPool().getThreadContext()));
        if (!this.doFlush(ctx)) {
            ctx.flush();
        }
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        assert (Transports.assertDefaultThreadContext(this.transport.getThreadPool().getThreadContext()));
        this.doFlush(ctx);
        Releasables.closeExpectNoException((Releasable)this.pipeline);
        super.channelInactive(ctx);
    }

    private boolean doFlush(ChannelHandlerContext ctx) {
        assert (ctx.executor().inEventLoop());
        Channel channel = ctx.channel();
        if (!channel.isActive()) {
            this.failQueuedWrites();
            return false;
        }
        boolean needsFlush = true;
        while (channel.isWritable()) {
            ByteBuf writeBuffer;
            boolean sliced;
            if (this.currentWrite == null) {
                this.currentWrite = this.queuedWrites.poll();
            }
            if (this.currentWrite == null) break;
            WriteOperation write = this.currentWrite;
            int readableBytes = write.buf.readableBytes();
            int bufferSize = Math.min(readableBytes, 262144);
            int readerIndex = write.buf.readerIndex();
            boolean bl = sliced = readableBytes != bufferSize;
            if (sliced) {
                writeBuffer = write.buf.retainedSlice(readerIndex, bufferSize);
                write.buf.readerIndex(readerIndex + bufferSize);
            } else {
                writeBuffer = write.buf;
            }
            ChannelFuture writeFuture = ctx.write(writeBuffer);
            needsFlush = true;
            if (!sliced) {
                this.currentWrite = null;
                writeFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                    assert (ctx.executor().inEventLoop());
                    if (future.isSuccess()) {
                        write.promise.trySuccess();
                    } else {
                        write.promise.tryFailure(future.cause());
                    }
                }));
            } else {
                writeFuture.addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                    assert (ctx.executor().inEventLoop());
                    if (!future.isSuccess()) {
                        write.promise.tryFailure(future.cause());
                    }
                }));
            }
            if (channel.isWritable()) continue;
            ctx.flush();
            needsFlush = false;
        }
        if (needsFlush) {
            ctx.flush();
        }
        if (!channel.isActive()) {
            this.failQueuedWrites();
        }
        return true;
    }

    private void failQueuedWrites() {
        WriteOperation queuedWrite;
        if (this.currentWrite != null) {
            WriteOperation current = this.currentWrite;
            this.currentWrite = null;
            current.failAsClosedChannel();
        }
        while ((queuedWrite = this.queuedWrites.poll()) != null) {
            queuedWrite.failAsClosedChannel();
        }
    }

    private static final class WriteOperation {
        private final ByteBuf buf;
        private final ChannelPromise promise;

        WriteOperation(ByteBuf buf, ChannelPromise promise) {
            this.buf = buf;
            this.promise = promise;
        }

        void failAsClosedChannel() {
            this.promise.tryFailure(new ClosedChannelException());
            this.buf.release();
        }
    }
}

