/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.nio;

import java.nio.channels.SocketChannel;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.nio.NioSocketChannel;
import org.elasticsearch.transport.TcpChannel;

public class NioTcpChannel
extends NioSocketChannel
implements TcpChannel {
    private final boolean isServer;
    private final String profile;
    private final TcpChannel.ChannelStats stats = new TcpChannel.ChannelStats();

    public NioTcpChannel(boolean isServer, String profile, SocketChannel socketChannel) {
        super(socketChannel);
        this.isServer = isServer;
        this.profile = profile;
    }

    @Override
    public void sendMessage(BytesReference reference, ActionListener<Void> listener) {
        this.getContext().sendMessage(BytesReference.toByteBuffers(reference), ActionListener.toBiConsumer(listener));
    }

    @Override
    public boolean isServerChannel() {
        return this.isServer;
    }

    @Override
    public String getProfile() {
        return this.profile;
    }

    @Override
    public void addCloseListener(ActionListener<Void> listener) {
        this.addCloseListener(ActionListener.toBiConsumer(listener));
    }

    @Override
    public void addConnectListener(ActionListener<Void> listener) {
        this.addConnectListener(ActionListener.toBiConsumer(listener));
    }

    @Override
    public TcpChannel.ChannelStats getChannelStats() {
        return this.stats;
    }

    @Override
    public void close() {
        this.getContext().closeChannel();
    }

    @Override
    public String toString() {
        return "TcpNioSocketChannel{localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.getRemoteAddress() + ", profile=" + this.profile + '}';
    }
}

