/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.action;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.function.BiConsumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.protocol.xpack.XPackUsageRequest;
import org.elasticsearch.tasks.CancellableTask;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.transport.Transports;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.action.XPackUsageResponse;
import org.elasticsearch.xpack.core.common.IteratingActionListener;

public class TransportXPackUsageAction
extends TransportMasterNodeAction<XPackUsageRequest, XPackUsageResponse> {
    private final List<XPackFeatureSet> featureSets;

    @Inject
    public TransportXPackUsageAction(ThreadPool threadPool, TransportService transportService, ClusterService clusterService, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Set<XPackFeatureSet> featureSets) {
        super("cluster:monitor/xpack/usage", transportService, clusterService, threadPool, actionFilters, XPackUsageRequest::new, indexNameExpressionResolver, XPackUsageResponse::new, "management");
        this.featureSets = Collections.unmodifiableList(new ArrayList<XPackFeatureSet>(featureSets));
    }

    @Override
    protected void masterOperation(XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageResponse> listener) {
        throw new UnsupportedOperationException("The task parameter is required");
    }

    @Override
    protected void masterOperation(Task task, XPackUsageRequest request, ClusterState state, ActionListener<XPackUsageResponse> listener) {
        ActionListener<List> usageActionListener = listener.delegateFailure((l, usages) -> l.onResponse(new XPackUsageResponse((List<XPackFeatureSet.Usage>)usages)));
        AtomicReferenceArray featureSetUsages = new AtomicReferenceArray(this.featureSets.size());
        AtomicInteger position = new AtomicInteger(0);
        BiConsumer<XPackFeatureSet, ActionListener> consumer = (featureSet, iteratingListener) -> {
            assert (Transports.assertNotTransportThread("calculating usage can be more expensive than we allow on transport threads"));
            if (task instanceof CancellableTask && ((CancellableTask)task).isCancelled()) {
                throw new CancellationException("Task cancelled");
            }
            featureSet.usage(iteratingListener.delegateFailure((l, usage) -> {
                featureSetUsages.set(position.getAndIncrement(), usage);
                this.threadPool.executor("management").execute(ActionRunnable.supply(iteratingListener, Collections::emptyList));
            }));
        };
        IteratingActionListener<List, XPackFeatureSet> iteratingActionListener = new IteratingActionListener<List, XPackFeatureSet>(usageActionListener, consumer, this.featureSets, this.threadPool.getThreadContext(), ignore -> {
            ArrayList<XPackFeatureSet.Usage> usageList = new ArrayList<XPackFeatureSet.Usage>(featureSetUsages.length());
            for (int i = 0; i < featureSetUsages.length(); ++i) {
                usageList.add((XPackFeatureSet.Usage)featureSetUsages.get(i));
            }
            return usageList;
        }, ignore -> true);
        iteratingActionListener.run();
    }

    @Override
    protected ClusterBlockException checkBlock(XPackUsageRequest request, ClusterState state) {
        return null;
    }
}

