/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xpack.core.ccr.action.UnfollowAction;
import org.elasticsearch.xpack.core.ilm.AbstractUnfollowIndexStep;
import org.elasticsearch.xpack.core.ilm.Step;

final class UnfollowFollowerIndexStep
extends AbstractUnfollowIndexStep {
    private static final Logger logger = LogManager.getLogger(UnfollowFollowerIndexStep.class);
    static final String NAME = "unfollow-follower-index";

    UnfollowFollowerIndexStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    void innerPerformAction(String followerIndex, ClusterState currentClusterState, ActionListener<Void> listener) {
        UnfollowAction.Request request = (UnfollowAction.Request)new UnfollowAction.Request(followerIndex).masterNodeTimeout(TimeValue.MAX_VALUE);
        this.getClient().execute(UnfollowAction.INSTANCE, request, ActionListener.wrap(r -> {
            if (!r.isAcknowledged()) {
                throw new ElasticsearchException("unfollow request failed to be acknowledged", new Object[0]);
            }
            listener.onResponse(null);
        }, exception -> {
            if (exception instanceof ElasticsearchException && ((ElasticsearchException)exception).getMetadata("es.failed_to_remove_retention_leases") != null) {
                List<String> leasesNotRemoved = ((ElasticsearchException)exception).getMetadata("es.failed_to_remove_retention_leases");
                logger.debug("failed to remove leader retention lease(s) {} while unfollowing index [{}], continuing with lifecycle execution", (Object)leasesNotRemoved, (Object)followerIndex);
                listener.onResponse(null);
            } else {
                listener.onFailure((Exception)exception);
            }
        }));
    }
}

