/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.datafeed;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.search.aggregations.AggregatorFactories;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;
import org.elasticsearch.xpack.core.ml.utils.XContentObjectTransformer;

class AggProvider
implements Writeable,
ToXContentObject {
    private static final Logger logger = LogManager.getLogger(AggProvider.class);
    private Exception parsingException;
    private AggregatorFactories.Builder parsedAggs;
    private Map<String, Object> aggs;

    static AggProvider fromXContent(XContentParser parser, boolean lenient) throws IOException {
        Map<String, Object> aggs = parser.mapOrdered();
        AggregatorFactories.Builder parsedAggs = null;
        Exception exception = null;
        try {
            if (aggs.isEmpty()) {
                throw new Exception("aggs cannot be empty");
            }
            parsedAggs = XContentObjectTransformer.aggregatorTransformer(parser.getXContentRegistry()).fromMap(aggs);
        }
        catch (Exception ex) {
            if (ex.getCause() instanceof IllegalArgumentException) {
                ex = (Exception)ex.getCause();
            }
            exception = ex;
            if (lenient) {
                logger.warn("Datafeed aggregations are not parsable", (Throwable)ex);
            }
            throw ExceptionsHelper.badRequestException("Datafeed aggregations are not parsable", ex, new Object[0]);
        }
        return new AggProvider(aggs, parsedAggs, exception);
    }

    static AggProvider fromParsedAggs(AggregatorFactories.Builder parsedAggs) throws IOException {
        return parsedAggs == null ? null : new AggProvider(XContentObjectTransformer.aggregatorTransformer(NamedXContentRegistry.EMPTY).toMap(parsedAggs), parsedAggs, null);
    }

    static AggProvider fromStream(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_6_7_0)) {
            return new AggProvider(in.readMap(), in.readOptionalWriteable(AggregatorFactories.Builder::new), (Exception)in.readException());
        }
        if (in.getVersion().onOrAfter(Version.V_6_6_0)) {
            return new AggProvider(in.readMap(), null, null);
        }
        return AggProvider.fromParsedAggs(new AggregatorFactories.Builder(in));
    }

    AggProvider(Map<String, Object> aggs, AggregatorFactories.Builder parsedAggs, Exception parsingException) {
        this.aggs = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(Objects.requireNonNull(aggs, "[aggs] must not be null")));
        this.parsedAggs = parsedAggs;
        this.parsingException = parsingException;
    }

    AggProvider(AggProvider other) {
        this.aggs = new LinkedHashMap<String, Object>(other.aggs);
        this.parsedAggs = other.parsedAggs;
        this.parsingException = other.parsingException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().onOrAfter(Version.V_6_7_0)) {
            out.writeMap(this.aggs);
            out.writeOptionalWriteable(this.parsedAggs);
            out.writeException(this.parsingException);
        } else if (out.getVersion().onOrAfter(Version.V_6_6_0)) {
            out.writeMap(this.aggs);
        } else {
            if (this.parsingException != null) {
                if (this.parsingException instanceof IOException) {
                    throw (IOException)this.parsingException;
                }
                throw new ElasticsearchException(this.parsingException);
            }
            if (this.parsedAggs == null) {
                throw new ElasticsearchException("Unsupported operation: parsed aggregations are null", new Object[0]);
            }
            this.parsedAggs.writeTo(out);
        }
    }

    public Exception getParsingException() {
        return this.parsingException;
    }

    AggregatorFactories.Builder getParsedAggs() {
        return this.parsedAggs;
    }

    public Map<String, Object> getAggs() {
        return this.aggs;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        AggProvider that = (AggProvider)other;
        return Objects.equals(this.aggs, that.aggs) && Objects.equals(this.parsedAggs, that.parsedAggs) && Objects.equals(this.parsingException, that.parsingException);
    }

    public int hashCode() {
        return Objects.hash(this.aggs, this.parsedAggs, this.parsingException);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.map(this.aggs);
        return builder;
    }
}

