/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe;

import java.io.IOException;
import java.util.Arrays;
import java.util.Locale;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.core.ml.utils.MemoryTrackedTaskState;

public enum DataFrameAnalyticsState implements Writeable,
MemoryTrackedTaskState
{
    STARTED,
    REINDEXING,
    ANALYZING,
    STOPPING,
    STOPPED,
    FAILED,
    STARTING;


    public static DataFrameAnalyticsState fromString(String name) {
        return DataFrameAnalyticsState.valueOf(name.trim().toUpperCase(Locale.ROOT));
    }

    public static DataFrameAnalyticsState fromStream(StreamInput in) throws IOException {
        return in.readEnum(DataFrameAnalyticsState.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        DataFrameAnalyticsState toWrite = this;
        if (out.getVersion().before(Version.V_7_5_0) && toWrite == STARTING) {
            toWrite = STOPPED;
        }
        out.writeEnum(toWrite);
    }

    public String toString() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public boolean isAnyOf(DataFrameAnalyticsState ... candidates) {
        return Arrays.stream(candidates).anyMatch(candidate -> this == candidate);
    }

    public boolean isNoneOf(DataFrameAnalyticsState ... candidates) {
        return Arrays.stream(candidates).noneMatch(candidate -> this == candidate);
    }

    @Override
    public boolean consumesMemory() {
        return this.isNoneOf(FAILED, STOPPED);
    }
}

