/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.dataframe.evaluation.classification;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class PerClassSingleValue
implements ToXContentObject,
Writeable {
    private static final ParseField CLASS_NAME = new ParseField("class_name", new String[0]);
    private static final ParseField VALUE = new ParseField("value", new String[0]);
    public static final ConstructingObjectParser<PerClassSingleValue, Void> PARSER = new ConstructingObjectParser("per_class_result", true, a -> new PerClassSingleValue((String)a[0], (Double)a[1]));
    private final String className;
    private final double value;

    public PerClassSingleValue(String className, double value) {
        this.className = ExceptionsHelper.requireNonNull(className, CLASS_NAME);
        this.value = value;
    }

    public PerClassSingleValue(StreamInput in) throws IOException {
        this.className = in.readString();
        this.value = in.readDouble();
    }

    public String getClassName() {
        return this.className;
    }

    public double getValue() {
        return this.value;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.className);
        out.writeDouble(this.value);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(CLASS_NAME.getPreferredName(), this.className);
        builder.field(VALUE.getPreferredName(), this.value);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PerClassSingleValue that = (PerClassSingleValue)o;
        return Objects.equals(this.className, that.className) && this.value == that.value;
    }

    public int hashCode() {
        return Objects.hash(this.className, this.value);
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), CLASS_NAME);
        PARSER.declareDouble(ConstructingObjectParser.constructorArg(), VALUE);
    }
}

