/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.inference;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.xcontent.ObjectParser;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.TrainedModelDefinition;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.LenientlyParsedPreProcessor;
import org.elasticsearch.xpack.core.ml.inference.preprocessing.PreProcessor;
import org.elasticsearch.xpack.core.ml.inference.results.InferenceResults;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.InferenceConfig;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.inference.InferenceModel;
import org.elasticsearch.xpack.core.ml.utils.ExceptionsHelper;

public class InferenceDefinition {
    public static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(InferenceDefinition.class);
    public static final String NAME = "inference_model_definition";
    private final InferenceModel trainedModel;
    private final List<PreProcessor> preProcessors;
    private Map<String, String> decoderMap;
    private static final ObjectParser<Builder, Void> PARSER = new ObjectParser("inference_model_definition", true, Builder::new);

    public static InferenceDefinition fromXContent(XContentParser parser) {
        return PARSER.apply(parser, null).build();
    }

    public InferenceDefinition(InferenceModel trainedModel, List<PreProcessor> preProcessors) {
        this.trainedModel = ExceptionsHelper.requireNonNull(trainedModel, TrainedModelDefinition.TRAINED_MODEL);
        this.preProcessors = preProcessors == null ? Collections.emptyList() : Collections.unmodifiableList(preProcessors);
    }

    public long ramBytesUsed() {
        long size = SHALLOW_SIZE;
        size += RamUsageEstimator.sizeOf(this.trainedModel);
        return size += RamUsageEstimator.sizeOfCollection(this.preProcessors);
    }

    InferenceModel getTrainedModel() {
        return this.trainedModel;
    }

    private void preProcess(Map<String, Object> fields) {
        this.preProcessors.forEach(preProcessor -> preProcessor.process(fields));
    }

    public InferenceResults infer(Map<String, Object> fields, InferenceConfig config) {
        this.preProcess(fields);
        if (config.requestingImportance() && !this.trainedModel.supportsFeatureImportance()) {
            throw ExceptionsHelper.badRequestException("Feature importance is not supported for the configured model of type [{}]", this.trainedModel.getName());
        }
        return this.trainedModel.infer(fields, config, config.requestingImportance() ? this.getDecoderMap() : Collections.emptyMap());
    }

    public TargetType getTargetType() {
        return this.trainedModel.targetType();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, String> getDecoderMap() {
        if (this.decoderMap != null) {
            return this.decoderMap;
        }
        InferenceDefinition inferenceDefinition = this;
        synchronized (inferenceDefinition) {
            if (this.decoderMap != null) {
                return this.decoderMap;
            }
            this.decoderMap = this.preProcessors.stream().filter(p -> !p.isCustom()).map(PreProcessor::reverseLookup).collect(HashMap::new, Map::putAll, Map::putAll);
            return this.decoderMap;
        }
    }

    public String toString() {
        return "InferenceDefinition{trainedModel=" + this.trainedModel + ", preProcessors=" + this.preProcessors + ", decoderMap=" + this.decoderMap + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    static {
        PARSER.declareNamedObject(Builder::setTrainedModel, (p, c, n) -> p.namedObject(InferenceModel.class, n, null), TrainedModelDefinition.TRAINED_MODEL);
        PARSER.declareNamedObjects(Builder::setPreProcessors, (p, c, n) -> p.namedObject(LenientlyParsedPreProcessor.class, n, PreProcessor.PreProcessorParseContext.DEFAULT), trainedModelDefBuilder -> {}, TrainedModelDefinition.PREPROCESSORS);
    }

    public static class Builder {
        private List<PreProcessor> preProcessors;
        private InferenceModel inferenceModel;

        public Builder setPreProcessors(List<PreProcessor> preProcessors) {
            this.preProcessors = preProcessors;
            return this;
        }

        public Builder setTrainedModel(InferenceModel trainedModel) {
            this.inferenceModel = trainedModel;
            return this;
        }

        public InferenceDefinition build() {
            this.inferenceModel.rewriteFeatureIndices(Collections.emptyMap());
            return new InferenceDefinition(this.inferenceModel, this.preProcessors);
        }
    }
}

