/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.rollup;

import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.fieldcaps.FieldCapabilities;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.NamedWriteable;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.rollup.RollupActionGroupConfig;
import org.elasticsearch.xpack.core.rollup.job.MetricConfig;

public class RollupActionConfig
implements NamedWriteable,
ToXContentObject {
    private static final String NAME = "xpack/rollup/action/config";
    private final RollupActionGroupConfig groupConfig;
    private final List<MetricConfig> metricsConfig;
    private static final ConstructingObjectParser<RollupActionConfig, Void> PARSER = new ConstructingObjectParser("xpack/rollup/action/config", false, args -> {
        RollupActionGroupConfig groupConfig = (RollupActionGroupConfig)args[0];
        List metricsConfig = (List)args[1];
        return new RollupActionConfig(groupConfig, metricsConfig);
    });

    public RollupActionConfig(RollupActionGroupConfig groupConfig, List<MetricConfig> metricsConfig) {
        if (groupConfig == null && (metricsConfig == null || metricsConfig.isEmpty())) {
            throw new IllegalArgumentException("At least one grouping or metric must be configured");
        }
        if (metricsConfig == null || metricsConfig.isEmpty()) {
            throw new IllegalArgumentException("At least one metric must be configured");
        }
        this.groupConfig = groupConfig;
        this.metricsConfig = metricsConfig != null ? metricsConfig : Collections.emptyList();
    }

    public RollupActionConfig(StreamInput in) throws IOException {
        this.groupConfig = in.readOptionalWriteable(RollupActionGroupConfig::new);
        this.metricsConfig = in.readList(MetricConfig::new);
    }

    public RollupActionGroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    public List<MetricConfig> getMetricsConfig() {
        return this.metricsConfig;
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    public Set<String> getAllFields() {
        HashSet<String> fields = new HashSet<String>();
        if (this.groupConfig != null) {
            fields.addAll(this.groupConfig.getAllFields());
        }
        if (this.metricsConfig != null) {
            for (MetricConfig metric : this.metricsConfig) {
                fields.add(metric.getField());
            }
        }
        return Collections.unmodifiableSet(fields);
    }

    public void validateMappings(Map<String, Map<String, FieldCapabilities>> fieldCapsResponse, ActionRequestValidationException validationException) {
        this.groupConfig.validateMappings(fieldCapsResponse, validationException);
        for (MetricConfig m : this.metricsConfig) {
            m.validateMappings(fieldCapsResponse, validationException);
        }
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.groupConfig != null) {
            builder.field("groups", this.groupConfig);
        }
        if (this.metricsConfig != null) {
            builder.startArray("metrics");
            for (MetricConfig metric : this.metricsConfig) {
                metric.toXContent(builder, params);
            }
            builder.endArray();
        }
        builder.endObject();
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeOptionalWriteable(this.groupConfig);
        out.writeList(this.metricsConfig);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        RollupActionConfig that = (RollupActionConfig)other;
        return Objects.equals(this.groupConfig, that.groupConfig) && Objects.equals(this.metricsConfig, that.metricsConfig);
    }

    public int hashCode() {
        return Objects.hash(this.groupConfig, this.metricsConfig);
    }

    public String toString() {
        return Strings.toString(this, true, true);
    }

    public static RollupActionConfig fromXContent(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    static {
        PARSER.declareObject(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> RollupActionGroupConfig.fromXContent(p), new ParseField("groups", new String[0]));
        PARSER.declareObjectArray(ConstructingObjectParser.optionalConstructorArg(), (p, c) -> MetricConfig.fromXContent(p), new ParseField("metrics", new String[0]));
    }
}

