/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.searchablesnapshots;

import java.util.Map;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.snapshots.SearchableSnapshotsSettings;
import org.elasticsearch.xpack.core.XPackFeatureSet;
import org.elasticsearch.xpack.core.searchablesnapshots.SearchableSnapshotFeatureSetUsage;
import org.elasticsearch.xpack.core.searchablesnapshots.SearchableSnapshotsConstants;

public class SearchableSnapshotsFeatureSet
implements XPackFeatureSet {
    private final XPackLicenseState licenseState;
    private final ClusterService clusterService;

    @Inject
    public SearchableSnapshotsFeatureSet(@Nullable XPackLicenseState licenseState, ClusterService clusterService) {
        this.licenseState = licenseState;
        this.clusterService = clusterService;
    }

    @Override
    public String name() {
        return "searchable_snapshots";
    }

    @Override
    public boolean available() {
        return this.licenseState.isAllowed(XPackLicenseState.Feature.SEARCHABLE_SNAPSHOTS);
    }

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public Map<String, Object> nativeCodeInfo() {
        return null;
    }

    @Override
    public void usage(ActionListener<XPackFeatureSet.Usage> listener) {
        ClusterState state = this.clusterService.state();
        int numFullCopySnapIndices = 0;
        int numSharedCacheSnapIndices = 0;
        for (IndexMetadata indexMetadata : state.metadata()) {
            if (!SearchableSnapshotsSettings.isSearchableSnapshotStore(indexMetadata.getSettings())) continue;
            if (SearchableSnapshotsConstants.SNAPSHOT_PARTIAL_SETTING.get(indexMetadata.getSettings()).booleanValue()) {
                ++numSharedCacheSnapIndices;
                continue;
            }
            ++numFullCopySnapIndices;
        }
        listener.onResponse(new SearchableSnapshotFeatureSetUsage(this.available(), numFullCopySnapIndices, numSharedCacheSnapIndices));
    }
}

