/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.oidc;

import java.io.IOException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public class OpenIdConnectPrepareAuthenticationRequest
extends ActionRequest {
    private String realmName;
    private String issuer;
    private String loginHint;
    private String state;
    private String nonce;

    public String getRealmName() {
        return this.realmName;
    }

    public String getState() {
        return this.state;
    }

    public String getNonce() {
        return this.nonce;
    }

    public String getIssuer() {
        return this.issuer;
    }

    public String getLoginHint() {
        return this.loginHint;
    }

    public void setRealmName(String realmName) {
        this.realmName = realmName;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setState(String state) {
        this.state = state;
    }

    public void setNonce(String nonce) {
        this.nonce = nonce;
    }

    public void setLoginHint(String loginHint) {
        this.loginHint = loginHint;
    }

    public OpenIdConnectPrepareAuthenticationRequest() {
    }

    public OpenIdConnectPrepareAuthenticationRequest(StreamInput in) throws IOException {
        super(in);
        this.realmName = in.readOptionalString();
        this.issuer = in.readOptionalString();
        this.loginHint = in.readOptionalString();
        this.state = in.readOptionalString();
        this.nonce = in.readOptionalString();
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (!Strings.hasText(this.realmName) && !Strings.hasText(this.issuer)) {
            validationException = ValidateActions.addValidationError("one of [realm, issuer] must be provided", null);
        }
        if (Strings.hasText(this.realmName) && Strings.hasText(this.issuer)) {
            validationException = ValidateActions.addValidationError("only one of [realm, issuer] can be provided in the same request", null);
        }
        return validationException;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeOptionalString(this.realmName);
        out.writeOptionalString(this.issuer);
        out.writeOptionalString(this.loginHint);
        out.writeOptionalString(this.state);
        out.writeOptionalString(this.nonce);
    }

    @Override
    public String toString() {
        return "{realmName=" + this.realmName + ", issuer=" + this.issuer + ", login_hint=" + this.loginHint + ", state=" + this.state + ", nonce=" + this.nonce + "}";
    }
}

