/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.service;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xpack.core.security.support.Validation;

public class CreateServiceAccountTokenRequest
extends ActionRequest {
    private final String namespace;
    private final String serviceName;
    private final String tokenName;
    private WriteRequest.RefreshPolicy refreshPolicy = WriteRequest.RefreshPolicy.WAIT_UNTIL;

    public CreateServiceAccountTokenRequest(String namespace, String serviceName, String tokenName) {
        this.namespace = namespace;
        this.serviceName = serviceName;
        this.tokenName = tokenName;
    }

    public CreateServiceAccountTokenRequest(StreamInput in) throws IOException {
        super(in);
        this.namespace = in.readString();
        this.serviceName = in.readString();
        this.tokenName = in.readString();
        this.refreshPolicy = WriteRequest.RefreshPolicy.readFrom(in);
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public WriteRequest.RefreshPolicy getRefreshPolicy() {
        return this.refreshPolicy;
    }

    public void setRefreshPolicy(WriteRequest.RefreshPolicy refreshPolicy) {
        this.refreshPolicy = Objects.requireNonNull(refreshPolicy, "refresh policy may not be null");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateServiceAccountTokenRequest that = (CreateServiceAccountTokenRequest)o;
        return Objects.equals(this.namespace, that.namespace) && Objects.equals(this.serviceName, that.serviceName) && Objects.equals(this.tokenName, that.tokenName) && this.refreshPolicy == that.refreshPolicy;
    }

    public int hashCode() {
        return Objects.hash(this.namespace, this.serviceName, this.tokenName, this.refreshPolicy);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.namespace);
        out.writeString(this.serviceName);
        out.writeString(this.tokenName);
        this.refreshPolicy.writeTo(out);
    }

    @Override
    public ActionRequestValidationException validate() {
        ActionRequestValidationException validationException = null;
        if (Strings.isNullOrEmpty(this.namespace)) {
            validationException = ValidateActions.addValidationError("service account namespace is required", validationException);
        }
        if (Strings.isNullOrEmpty(this.serviceName)) {
            validationException = ValidateActions.addValidationError("service account service-name is required", validationException);
        }
        if (!Validation.isValidServiceAccountTokenName(this.tokenName)) {
            validationException = ValidateActions.addValidationError(Validation.formatInvalidServiceTokenNameErrorMessage(this.tokenName), validationException);
        }
        return validationException;
    }
}

