/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.AllExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.AnyExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExceptExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.FieldExpression;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.RoleMapperExpression;
import org.elasticsearch.xpack.core.watcher.support.xcontent.XContentSource;

public final class ExpressionParser {
    public static RoleMapperExpression readExpression(StreamInput in) throws IOException {
        return in.readNamedWriteable(RoleMapperExpression.class);
    }

    public static void writeExpression(RoleMapperExpression expression, StreamOutput out) throws IOException {
        out.writeNamedWriteable(expression);
    }

    static List<RoleMapperExpression> readExpressionList(StreamInput in) throws IOException {
        return in.readNamedWriteableList(RoleMapperExpression.class);
    }

    static void writeExpressionList(List<RoleMapperExpression> list, StreamOutput out) throws IOException {
        out.writeNamedWriteableList(list);
    }

    public static RoleMapperExpression parseObject(XContentParser parser, String id) throws IOException {
        return new ExpressionParser().parse(id, parser);
    }

    public RoleMapperExpression parse(String name, XContentSource content) throws IOException {
        try (StreamInput stream = content.getBytes().streamInput();){
            RoleMapperExpression roleMapperExpression = this.parse(name, content.parser(NamedXContentRegistry.EMPTY, stream));
            return roleMapperExpression;
        }
    }

    public RoleMapperExpression parse(String name, XContentParser parser) throws IOException {
        return this.parseRulesObject(name, parser, false);
    }

    private RoleMapperExpression parseRulesObject(String objectName, XContentParser parser, boolean allowExcept) throws IOException {
        XContentParser.Token token = parser.currentToken() == null ? parser.nextToken() : parser.currentToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("failed to parse rules expression. expected [{}] to be an object but found [{}] instead", new Object[]{objectName, token});
        }
        String fieldName = this.readFieldName(objectName, parser);
        RoleMapperExpression expr = this.parseExpression(parser, fieldName, allowExcept, objectName);
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("failed to parse rules expression. object [{}] contains multiple fields", objectName);
        }
        return expr;
    }

    private RoleMapperExpression parseExpression(XContentParser parser, String field, boolean allowExcept, String objectName) throws IOException {
        if (Fields.ANY.match(field, parser.getDeprecationHandler())) {
            return new AnyExpression(this.parseExpressionArray(Fields.ANY, parser, false));
        }
        if (Fields.ALL.match(field, parser.getDeprecationHandler())) {
            return new AllExpression(this.parseExpressionArray(Fields.ALL, parser, true));
        }
        if (Fields.FIELD.match(field, parser.getDeprecationHandler())) {
            return this.parseFieldExpression(parser);
        }
        if (Fields.EXCEPT.match(field, parser.getDeprecationHandler())) {
            if (allowExcept) {
                return this.parseExceptExpression(parser);
            }
            throw new ElasticsearchParseException("failed to parse rules expression. field [{}] is not allowed within [{}]", field, objectName);
        }
        throw new ElasticsearchParseException("failed to parse rules expression. field [{}] is not recognised in object [{}]", field, objectName);
    }

    private RoleMapperExpression parseFieldExpression(XContentParser parser) throws IOException {
        this.checkStartObject(parser);
        String fieldName = this.readFieldName(Fields.FIELD.getPreferredName(), parser);
        List<FieldExpression.FieldValue> values = parser.nextToken() == XContentParser.Token.START_ARRAY ? this.parseArray(Fields.FIELD, parser, this::parseFieldValue) : Collections.singletonList(this.parseFieldValue(parser));
        if (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            throw new ElasticsearchParseException("failed to parse rules expression. object [{}] contains multiple fields", Fields.FIELD.getPreferredName());
        }
        return new FieldExpression(fieldName, values);
    }

    private RoleMapperExpression parseExceptExpression(XContentParser parser) throws IOException {
        this.checkStartObject(parser);
        return new ExceptExpression(this.parseRulesObject(Fields.EXCEPT.getPreferredName(), parser, false));
    }

    private void checkStartObject(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.nextToken();
        if (token != XContentParser.Token.START_OBJECT) {
            throw new ElasticsearchParseException("failed to parse rules expression. expected an object but found [{}] instead", new Object[]{token});
        }
    }

    private String readFieldName(String objectName, XContentParser parser) throws IOException {
        if (parser.nextToken() != XContentParser.Token.FIELD_NAME) {
            throw new ElasticsearchParseException("failed to parse rules expression. object [{}] does not contain any fields", objectName);
        }
        return parser.currentName();
    }

    private List<RoleMapperExpression> parseExpressionArray(ParseField field, XContentParser parser, boolean allowExcept) throws IOException {
        parser.nextToken();
        return this.parseArray(field, parser, p -> this.parseRulesObject(field.getPreferredName(), (XContentParser)p, allowExcept));
    }

    private <T> List<T> parseArray(ParseField field, XContentParser parser, CheckedFunction<XContentParser, T, IOException> elementParser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == XContentParser.Token.START_ARRAY) {
            ArrayList<T> list = new ArrayList<T>();
            while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                list.add(elementParser.apply(parser));
            }
            return list;
        }
        throw new ElasticsearchParseException("failed to parse rules expression. field [{}] requires an array", field);
    }

    private FieldExpression.FieldValue parseFieldValue(XContentParser parser) throws IOException {
        switch (parser.currentToken()) {
            case VALUE_STRING: {
                return new FieldExpression.FieldValue(parser.text());
            }
            case VALUE_BOOLEAN: {
                return new FieldExpression.FieldValue(parser.booleanValue());
            }
            case VALUE_NUMBER: {
                return new FieldExpression.FieldValue(parser.longValue());
            }
            case VALUE_NULL: {
                return new FieldExpression.FieldValue(null);
            }
        }
        throw new ElasticsearchParseException("failed to parse rules expression. expected a field value but found [{}] instead", new Object[]{parser.currentToken()});
    }

    public static interface Fields {
        public static final ParseField ANY = new ParseField("any", new String[0]);
        public static final ParseField ALL = new ParseField("all", new String[0]);
        public static final ParseField EXCEPT = new ParseField("except", new String[0]);
        public static final ParseField FIELD = new ParseField("field", new String[0]);
    }
}

