/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.permission;

import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.automaton.Automata;
import org.apache.lucene.util.automaton.Automaton;
import org.apache.lucene.util.automaton.CharacterRunAutomaton;
import org.apache.lucene.util.automaton.MinimizationOperations;
import org.apache.lucene.util.automaton.Operations;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.security.authz.accesscontrol.FieldSubsetReader;
import org.elasticsearch.xpack.core.security.authz.permission.FieldPermissionsDefinition;
import org.elasticsearch.xpack.core.security.authz.support.SecurityQueryTemplateEvaluator;
import org.elasticsearch.xpack.core.security.support.Automatons;
import org.elasticsearch.xpack.core.security.support.CacheKey;

public final class FieldPermissions
implements Accountable,
CacheKey {
    public static final FieldPermissions DEFAULT = new FieldPermissions();
    private static final long BASE_FIELD_PERM_DEF_BYTES = RamUsageEstimator.shallowSizeOf(new FieldPermissionsDefinition(null, null));
    private static final long BASE_FIELD_GROUP_BYTES = RamUsageEstimator.shallowSizeOf(new FieldPermissionsDefinition.FieldGrantExcludeGroup(null, null));
    private static final long BASE_HASHSET_ENTRY_SIZE;
    private final FieldPermissionsDefinition fieldPermissionsDefinition;
    @Nullable
    private final FieldPermissionsDefinition limitedByFieldPermissionsDefinition;
    private final CharacterRunAutomaton permittedFieldsAutomaton;
    private final boolean permittedFieldsAutomatonIsTotal;
    private final Automaton originalAutomaton;
    private final long ramBytesUsed;

    public FieldPermissions() {
        this(new FieldPermissionsDefinition(null, null), Automatons.MATCH_ALL);
    }

    public FieldPermissions(FieldPermissionsDefinition fieldPermissionsDefinition) {
        this(fieldPermissionsDefinition, FieldPermissions.initializePermittedFieldsAutomaton(fieldPermissionsDefinition));
    }

    FieldPermissions(FieldPermissionsDefinition fieldPermissionsDefinition, Automaton permittedFieldsAutomaton) {
        this(fieldPermissionsDefinition, null, permittedFieldsAutomaton);
    }

    private FieldPermissions(FieldPermissionsDefinition fieldPermissionsDefinition, @Nullable FieldPermissionsDefinition limitedByFieldPermissionsDefinition, Automaton permittedFieldsAutomaton) {
        if (!permittedFieldsAutomaton.isDeterministic() && permittedFieldsAutomaton.getNumStates() > 1) {
            throw new IllegalArgumentException("Only accepts deterministic automata");
        }
        this.fieldPermissionsDefinition = Objects.requireNonNull(fieldPermissionsDefinition, "field permission definition cannot be null");
        this.limitedByFieldPermissionsDefinition = limitedByFieldPermissionsDefinition;
        this.originalAutomaton = permittedFieldsAutomaton;
        this.permittedFieldsAutomaton = new CharacterRunAutomaton(permittedFieldsAutomaton);
        this.permittedFieldsAutomatonIsTotal = Operations.isTotal(permittedFieldsAutomaton);
        long ramBytesUsed = BASE_FIELD_PERM_DEF_BYTES;
        ramBytesUsed += FieldPermissions.ramBytesUsedForFieldPermissionsDefinition(this.fieldPermissionsDefinition);
        if (this.limitedByFieldPermissionsDefinition != null) {
            ramBytesUsed += FieldPermissions.ramBytesUsedForFieldPermissionsDefinition(this.limitedByFieldPermissionsDefinition);
        }
        ramBytesUsed += permittedFieldsAutomaton.ramBytesUsed();
        this.ramBytesUsed = ramBytesUsed += FieldPermissions.runAutomatonRamBytesUsed(permittedFieldsAutomaton);
    }

    private static long ramBytesUsedForFieldPermissionsDefinition(FieldPermissionsDefinition fpd) {
        long ramBytesUsed = 0L;
        for (FieldPermissionsDefinition.FieldGrantExcludeGroup group : fpd.getFieldGrantExcludeGroups()) {
            ramBytesUsed += BASE_FIELD_GROUP_BYTES + BASE_HASHSET_ENTRY_SIZE;
            if (group.getGrantedFields() != null) {
                ramBytesUsed += RamUsageEstimator.shallowSizeOf(group.getGrantedFields());
            }
            if (group.getExcludedFields() == null) continue;
            ramBytesUsed += RamUsageEstimator.shallowSizeOf(group.getExcludedFields());
        }
        return ramBytesUsed;
    }

    private static long runAutomatonRamBytesUsed(Automaton a) {
        return a.getNumStates() * 5;
    }

    public static Automaton initializePermittedFieldsAutomaton(FieldPermissionsDefinition fieldPermissionsDefinition) {
        Set<FieldPermissionsDefinition.FieldGrantExcludeGroup> groups = fieldPermissionsDefinition.getFieldGrantExcludeGroups();
        assert (groups.size() > 0) : "there must always be a single group for field inclusion/exclusion";
        List<Automaton> automatonList = groups.stream().map(g -> FieldPermissions.buildPermittedFieldsAutomaton(g.getGrantedFields(), g.getExcludedFields())).collect(Collectors.toList());
        return Automatons.unionAndMinimize(automatonList);
    }

    public static Automaton buildPermittedFieldsAutomaton(String[] grantedFields, String[] deniedFields) {
        Automaton grantedFieldsAutomaton;
        if (grantedFields == null || Arrays.stream(grantedFields).anyMatch(Regex::isMatchAllPattern)) {
            grantedFieldsAutomaton = Automatons.MATCH_ALL;
        } else {
            Automaton metaFieldsAutomaton = Operations.concatenate(Automata.makeChar(95), Automata.makeAnyString());
            grantedFieldsAutomaton = Operations.union(Automatons.patterns(grantedFields), metaFieldsAutomaton);
        }
        Automaton deniedFieldsAutomaton = deniedFields == null || deniedFields.length == 0 ? Automatons.EMPTY : Automatons.patterns(deniedFields);
        grantedFieldsAutomaton = MinimizationOperations.minimize(grantedFieldsAutomaton, 10000);
        deniedFieldsAutomaton = MinimizationOperations.minimize(deniedFieldsAutomaton, 10000);
        if (!Operations.subsetOf(deniedFieldsAutomaton, grantedFieldsAutomaton)) {
            throw new ElasticsearchSecurityException("Exceptions for field permissions must be a subset of the granted fields but " + Strings.arrayToCommaDelimitedString(deniedFields) + " is not a subset of " + Strings.arrayToCommaDelimitedString(grantedFields), new Object[0]);
        }
        grantedFieldsAutomaton = Automatons.minusAndMinimize(grantedFieldsAutomaton, deniedFieldsAutomaton);
        return grantedFieldsAutomaton;
    }

    public FieldPermissions limitFieldPermissions(FieldPermissions limitedBy) {
        if (this.hasFieldLevelSecurity() && limitedBy != null && limitedBy.hasFieldLevelSecurity()) {
            Automaton permittedFieldsAutomaton = Automatons.intersectAndMinimize(this.getIncludeAutomaton(), limitedBy.getIncludeAutomaton());
            return new FieldPermissions(this.fieldPermissionsDefinition, limitedBy.fieldPermissionsDefinition, permittedFieldsAutomaton);
        }
        if (limitedBy != null && limitedBy.hasFieldLevelSecurity()) {
            return new FieldPermissions(limitedBy.getFieldPermissionsDefinition(), limitedBy.getIncludeAutomaton());
        }
        if (this.hasFieldLevelSecurity()) {
            return new FieldPermissions(this.getFieldPermissionsDefinition(), this.getIncludeAutomaton());
        }
        return DEFAULT;
    }

    public boolean grantsAccessTo(String fieldName) {
        return this.permittedFieldsAutomatonIsTotal || this.permittedFieldsAutomaton.run(fieldName);
    }

    public FieldPermissionsDefinition getFieldPermissionsDefinition() {
        return this.fieldPermissionsDefinition;
    }

    public FieldPermissionsDefinition getLimitedByFieldPermissionsDefinition() {
        return this.limitedByFieldPermissionsDefinition;
    }

    @Override
    public void buildCacheKey(StreamOutput out, SecurityQueryTemplateEvaluator.DlsQueryEvaluationContext context) throws IOException {
        this.fieldPermissionsDefinition.buildCacheKey(out, context);
        if (this.limitedByFieldPermissionsDefinition != null) {
            out.writeBoolean(true);
            this.limitedByFieldPermissionsDefinition.buildCacheKey(out, context);
        } else {
            out.writeBoolean(false);
        }
    }

    public boolean hasFieldLevelSecurity() {
        return !this.permittedFieldsAutomatonIsTotal;
    }

    public DirectoryReader filter(DirectoryReader reader) throws IOException {
        if (!this.hasFieldLevelSecurity()) {
            return reader;
        }
        return FieldSubsetReader.wrap(reader, this.permittedFieldsAutomaton);
    }

    Automaton getIncludeAutomaton() {
        return this.originalAutomaton;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FieldPermissions that = (FieldPermissions)o;
        return this.permittedFieldsAutomatonIsTotal == that.permittedFieldsAutomatonIsTotal && this.fieldPermissionsDefinition.equals(that.fieldPermissionsDefinition) && Objects.equals(this.limitedByFieldPermissionsDefinition, that.limitedByFieldPermissionsDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.fieldPermissionsDefinition, this.limitedByFieldPermissionsDefinition, this.permittedFieldsAutomatonIsTotal);
    }

    @Override
    public long ramBytesUsed() {
        return this.ramBytesUsed;
    }

    static {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put(FieldPermissions.class.getName(), new Object());
        long mapEntryShallowSize = RamUsageEstimator.shallowSizeOf(map.entrySet().iterator().next());
        BASE_HASHSET_ENTRY_SIZE = mapEntryShallowSize + (long)(2 * RamUsageEstimator.NUM_BYTES_OBJECT_REF);
    }
}

