/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authz.privilege;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.util.automaton.Automaton;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.core.security.authz.privilege.Privilege;
import org.elasticsearch.xpack.core.security.support.Automatons;

public final class IndexPrivilege
extends Privilege {
    private static final Logger logger = LogManager.getLogger(IndexPrivilege.class);
    private static final Automaton ALL_AUTOMATON = Automatons.patterns("indices:*", "internal:transport/proxy/indices:*");
    private static final Automaton READ_AUTOMATON = Automatons.patterns("indices:data/read/*");
    private static final Automaton READ_CROSS_CLUSTER_AUTOMATON = Automatons.patterns("internal:transport/proxy/indices:data/read/*", "indices:admin/shards/search_shards");
    private static final Automaton CREATE_AUTOMATON = Automatons.patterns("indices:data/write/index*", "indices:data/write/bulk*");
    private static final Automaton CREATE_DOC_AUTOMATON = Automatons.patterns("indices:data/write/index", "indices:data/write/index[*", "indices:data/write/index:op_type/create", "indices:data/write/bulk*");
    private static final Automaton INDEX_AUTOMATON = Automatons.patterns("indices:data/write/index*", "indices:data/write/bulk*", "indices:data/write/update*");
    private static final Automaton DELETE_AUTOMATON = Automatons.patterns("indices:data/write/delete*", "indices:data/write/bulk*");
    private static final Automaton WRITE_AUTOMATON = Automatons.patterns("indices:data/write/*", "indices:admin/mapping/auto_put");
    private static final Automaton MONITOR_AUTOMATON = Automatons.patterns("indices:monitor/*");
    private static final Automaton MANAGE_AUTOMATON = Automatons.unionAndMinimize(Arrays.asList(MONITOR_AUTOMATON, Automatons.patterns("indices:admin/*", "indices:data/read/field_caps*", "indices:data/read/xpack/rollup/get/index/caps*")));
    private static final Automaton CREATE_INDEX_AUTOMATON = Automatons.patterns("indices:admin/create", "indices:admin/auto_create", "indices:admin/data_stream/create");
    private static final Automaton DELETE_INDEX_AUTOMATON = Automatons.patterns("indices:admin/delete", "indices:admin/data_stream/delete");
    private static final Automaton VIEW_METADATA_AUTOMATON = Automatons.patterns("indices:admin/aliases/get", "indices:admin/aliases/exists", "indices:admin/get", "indices:admin/exists", "indices:admin/mappings/fields/get*", "indices:admin/mappings/get", "indices:admin/shards/search_shards", "indices:admin/types/exists", "indices:admin/validate/query*", "indices:monitor/settings/get", "indices:admin/ilm/explain", "indices:admin/data_stream/get", "indices:admin/resolve/index", "indices:data/read/field_caps*", "indices:data/read/xpack/rollup/get/index/caps*");
    private static final Automaton MANAGE_FOLLOW_INDEX_AUTOMATON = Automatons.patterns("indices:admin/xpack/ccr/put_follow", "indices:admin/xpack/ccr/unfollow", "indices:admin/close*", "indices:admin/data_stream/promote", "indices:admin/rollover");
    private static final Automaton MANAGE_LEADER_INDEX_AUTOMATON = Automatons.patterns("indices:admin/xpack/ccr/forget_follower*");
    private static final Automaton MANAGE_ILM_AUTOMATON = Automatons.patterns("indices:admin/ilm/*");
    private static final Automaton MAINTENANCE_AUTOMATON = Automatons.patterns("indices:admin/refresh*", "indices:admin/flush*", "indices:admin/synced_flush", "indices:admin/forcemerge*");
    private static final Automaton AUTO_CONFIGURE_AUTOMATON = Automatons.patterns("indices:admin/mapping/auto_put", "indices:admin/auto_create");
    public static final IndexPrivilege NONE = new IndexPrivilege("none", Automatons.EMPTY);
    public static final IndexPrivilege ALL = new IndexPrivilege("all", ALL_AUTOMATON);
    public static final IndexPrivilege READ = new IndexPrivilege("read", READ_AUTOMATON);
    public static final IndexPrivilege READ_CROSS_CLUSTER = new IndexPrivilege("read_cross_cluster", READ_CROSS_CLUSTER_AUTOMATON);
    public static final IndexPrivilege CREATE = new IndexPrivilege("create", CREATE_AUTOMATON);
    public static final IndexPrivilege INDEX = new IndexPrivilege("index", INDEX_AUTOMATON);
    public static final IndexPrivilege DELETE = new IndexPrivilege("delete", DELETE_AUTOMATON);
    public static final IndexPrivilege WRITE = new IndexPrivilege("write", WRITE_AUTOMATON);
    public static final IndexPrivilege CREATE_DOC = new IndexPrivilege("create_doc", CREATE_DOC_AUTOMATON);
    public static final IndexPrivilege MONITOR = new IndexPrivilege("monitor", MONITOR_AUTOMATON);
    public static final IndexPrivilege MANAGE = new IndexPrivilege("manage", MANAGE_AUTOMATON);
    public static final IndexPrivilege DELETE_INDEX = new IndexPrivilege("delete_index", DELETE_INDEX_AUTOMATON);
    public static final IndexPrivilege CREATE_INDEX = new IndexPrivilege("create_index", CREATE_INDEX_AUTOMATON);
    public static final IndexPrivilege VIEW_METADATA = new IndexPrivilege("view_index_metadata", VIEW_METADATA_AUTOMATON);
    public static final IndexPrivilege MANAGE_FOLLOW_INDEX = new IndexPrivilege("manage_follow_index", MANAGE_FOLLOW_INDEX_AUTOMATON);
    public static final IndexPrivilege MANAGE_LEADER_INDEX = new IndexPrivilege("manage_leader_index", MANAGE_LEADER_INDEX_AUTOMATON);
    public static final IndexPrivilege MANAGE_ILM = new IndexPrivilege("manage_ilm", MANAGE_ILM_AUTOMATON);
    public static final IndexPrivilege MAINTENANCE = new IndexPrivilege("maintenance", MAINTENANCE_AUTOMATON);
    public static final IndexPrivilege AUTO_CONFIGURE = new IndexPrivilege("auto_configure", AUTO_CONFIGURE_AUTOMATON);
    private static final Map<String, IndexPrivilege> VALUES = IndexPrivilege.sortByAccessLevel(org.elasticsearch.core.Map.ofEntries(org.elasticsearch.core.Map.entry("none", NONE), org.elasticsearch.core.Map.entry("all", ALL), org.elasticsearch.core.Map.entry("manage", MANAGE), org.elasticsearch.core.Map.entry("create_index", CREATE_INDEX), org.elasticsearch.core.Map.entry("monitor", MONITOR), org.elasticsearch.core.Map.entry("read", READ), org.elasticsearch.core.Map.entry("index", INDEX), org.elasticsearch.core.Map.entry("delete", DELETE), org.elasticsearch.core.Map.entry("write", WRITE), org.elasticsearch.core.Map.entry("create", CREATE), org.elasticsearch.core.Map.entry("create_doc", CREATE_DOC), org.elasticsearch.core.Map.entry("delete_index", DELETE_INDEX), org.elasticsearch.core.Map.entry("view_index_metadata", VIEW_METADATA), org.elasticsearch.core.Map.entry("read_cross_cluster", READ_CROSS_CLUSTER), org.elasticsearch.core.Map.entry("manage_follow_index", MANAGE_FOLLOW_INDEX), org.elasticsearch.core.Map.entry("manage_leader_index", MANAGE_LEADER_INDEX), org.elasticsearch.core.Map.entry("manage_ilm", MANAGE_ILM), org.elasticsearch.core.Map.entry("maintenance", MAINTENANCE), org.elasticsearch.core.Map.entry("auto_configure", AUTO_CONFIGURE)));
    public static final Predicate<String> ACTION_MATCHER = ALL.predicate();
    public static final Predicate<String> CREATE_INDEX_MATCHER = CREATE_INDEX.predicate();
    private static final ConcurrentHashMap<Set<String>, IndexPrivilege> CACHE = new ConcurrentHashMap();

    private IndexPrivilege(String name, Automaton automaton) {
        super(Collections.singleton(name), automaton);
    }

    private IndexPrivilege(Set<String> name, Automaton automaton) {
        super(name, automaton);
    }

    public static IndexPrivilege get(Set<String> name) {
        return CACHE.computeIfAbsent(name, theName -> {
            if (theName.isEmpty()) {
                return NONE;
            }
            return IndexPrivilege.resolve(theName);
        });
    }

    private static IndexPrivilege resolve(Set<String> name) {
        int size = name.size();
        if (size == 0) {
            throw new IllegalArgumentException("empty set should not be used");
        }
        HashSet<String> actions = new HashSet<String>();
        HashSet<Automaton> automata = new HashSet<Automaton>();
        for (String part : name) {
            IndexPrivilege indexPrivilege;
            if (ACTION_MATCHER.test(part = part.toLowerCase(Locale.ROOT))) {
                actions.add(IndexPrivilege.actionToPattern(part));
                continue;
            }
            IndexPrivilege indexPrivilege2 = indexPrivilege = part == null ? null : VALUES.get(part);
            if (indexPrivilege != null && size == 1) {
                return indexPrivilege;
            }
            if (indexPrivilege != null) {
                automata.add(indexPrivilege.automaton);
                continue;
            }
            String errorMessage = "unknown index privilege [" + part + "]. a privilege must be either one of the predefined fixed indices privileges [" + Strings.collectionToCommaDelimitedString(VALUES.entrySet()) + "] or a pattern over one of the available index actions";
            logger.debug(errorMessage);
            throw new IllegalArgumentException(errorMessage);
        }
        if (!actions.isEmpty()) {
            automata.add(Automatons.patterns(actions));
        }
        return new IndexPrivilege(name, Automatons.unionAndMinimize(automata));
    }

    static Map<String, IndexPrivilege> values() {
        return VALUES;
    }

    public static Set<String> names() {
        return Collections.unmodifiableSet(VALUES.keySet());
    }

    public static Collection<String> findPrivilegesThatGrant(String action) {
        return Collections.unmodifiableList(VALUES.entrySet().stream().filter(e -> ((IndexPrivilege)e.getValue()).predicate.test(action)).map(e -> (String)e.getKey()).collect(Collectors.toList()));
    }
}

