/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.termsenum.rest;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.action.RestToXContentListener;
import org.elasticsearch.xpack.core.termsenum.action.TermsEnumAction;
import org.elasticsearch.xpack.core.termsenum.action.TermsEnumRequest;

public class RestTermsEnumAction
extends BaseRestHandler {
    @Override
    public List<RestHandler.Route> routes() {
        return Collections.unmodifiableList(Arrays.asList(new RestHandler.Route(RestRequest.Method.GET, "/{index}/_terms_enum"), new RestHandler.Route(RestRequest.Method.POST, "/{index}/_terms_enum")));
    }

    @Override
    public String getName() {
        return "term_enum_action";
    }

    @Override
    public BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        try (XContentParser parser = request.contentOrSourceParamParser();){
            TermsEnumRequest termEnumRequest = TermsEnumAction.fromXContent(parser, Strings.splitStringByCommaToArray(request.param("index")));
            BaseRestHandler.RestChannelConsumer restChannelConsumer = channel -> client.execute(TermsEnumAction.INSTANCE, termEnumRequest, new RestToXContentListener((RestChannel)channel));
            return restChannelConsumer;
        }
    }
}

