/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.transform.transforms;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionRequestValidationException;
import org.elasticsearch.action.ValidateActions;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.query.AbstractQueryBuilder;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;

public class QueryConfig
extends AbstractDiffable<QueryConfig>
implements Writeable,
ToXContentObject {
    private static final Logger logger = LogManager.getLogger(QueryConfig.class);
    private final Map<String, Object> source;
    private final QueryBuilder query;

    public static QueryConfig matchAll() {
        return new QueryConfig(Collections.singletonMap("match_all", Collections.emptyMap()), new MatchAllQueryBuilder());
    }

    public QueryConfig(Map<String, Object> source, QueryBuilder query) {
        this.source = Objects.requireNonNull(source);
        this.query = query;
    }

    public QueryConfig(StreamInput in) throws IOException {
        this.source = in.readMap();
        this.query = in.readOptionalNamedWriteable(QueryBuilder.class);
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.map(this.source);
        return builder;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.source);
        out.writeOptionalNamedWriteable(this.query);
    }

    public QueryBuilder getQuery() {
        return this.query;
    }

    public static QueryConfig fromXContent(XContentParser parser, boolean lenient) throws IOException {
        NamedXContentRegistry registry = parser.getXContentRegistry();
        Map<String, Object> source = parser.mapOrdered();
        QueryBuilder query = null;
        try (XContentBuilder xContentBuilder = XContentFactory.jsonBuilder().map(source);
             XContentParser sourceParser = XContentType.JSON.xContent().createParser(registry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, BytesReference.bytes(xContentBuilder).streamInput());){
            query = AbstractQueryBuilder.parseInnerQueryBuilder(sourceParser);
        }
        catch (Exception e) {
            if (lenient) {
                logger.warn("Failed to parse query for transform", (Throwable)e);
            }
            throw e;
        }
        return new QueryConfig(source, query);
    }

    public int hashCode() {
        return Objects.hash(this.source, this.query);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || this.getClass() != other.getClass()) {
            return false;
        }
        QueryConfig that = (QueryConfig)other;
        return Objects.equals(this.source, that.source) && Objects.equals(this.query, that.query);
    }

    public ActionRequestValidationException validate(ActionRequestValidationException validationException) {
        if (this.query == null) {
            validationException = ValidateActions.addValidationError("source.query must not be null", validationException);
        }
        return validationException;
    }
}

