/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.analyzer;

import java.util.Arrays;
import java.util.List;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.FieldAttribute;
import org.elasticsearch.xpack.ql.expression.Literal;
import org.elasticsearch.xpack.ql.expression.predicate.logical.BinaryLogic;
import org.elasticsearch.xpack.ql.expression.predicate.operator.comparison.Equals;
import org.elasticsearch.xpack.ql.plan.logical.Filter;
import org.elasticsearch.xpack.ql.plan.logical.LogicalPlan;
import org.elasticsearch.xpack.ql.rule.Rule;
import org.elasticsearch.xpack.ql.type.DataTypes;

public final class AnalyzerRules {

    public static abstract class BaseAnalyzerRule
    extends AnalyzerRule<LogicalPlan> {
        @Override
        protected LogicalPlan rule(LogicalPlan plan) {
            if (!plan.childrenResolved()) {
                return plan;
            }
            return this.doRule(plan);
        }

        protected abstract LogicalPlan doRule(LogicalPlan var1);
    }

    public static abstract class AnalyzerRule<SubPlan extends LogicalPlan>
    extends Rule<SubPlan, LogicalPlan> {
        @Override
        public final LogicalPlan apply(LogicalPlan plan) {
            return plan.transformUp(this.typeToken(), t -> t.analyzed() || this.skipResolved() && t.resolved() ? t : this.rule((SubPlan)t));
        }

        @Override
        protected abstract LogicalPlan rule(SubPlan var1);

        protected boolean skipResolved() {
            return true;
        }
    }

    public static class AddMissingEqualsToBoolField
    extends AnalyzerRule<Filter> {
        @Override
        protected LogicalPlan rule(Filter filter) {
            if (!filter.resolved()) {
                return filter;
            }
            Expression condition = this.replaceRawBoolFieldWithEquals(filter.condition());
            if (condition == filter.condition()) {
                condition = condition.transformUp(BinaryLogic.class, b -> b.replaceChildren((List)Arrays.asList(this.replaceRawBoolFieldWithEquals(b.left()), this.replaceRawBoolFieldWithEquals(b.right()))));
            }
            if (condition != filter.condition()) {
                filter = filter.with(condition);
            }
            return filter;
        }

        private Expression replaceRawBoolFieldWithEquals(Expression e) {
            if (e instanceof FieldAttribute && e.dataType() == DataTypes.BOOLEAN) {
                e = new Equals(e.source(), e, Literal.of(e, Boolean.TRUE));
            }
            return e;
        }

        @Override
        protected boolean skipResolved() {
            return false;
        }
    }
}

