/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.common;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Collectors;
import org.elasticsearch.common.logging.LoggerMessageFormat;
import org.elasticsearch.xpack.ql.tree.Location;
import org.elasticsearch.xpack.ql.tree.Node;

public class Failure {
    private final Node<?> node;
    private final String message;

    public Failure(Node<?> node, String message) {
        this.node = node;
        this.message = message;
    }

    public Node<?> node() {
        return this.node;
    }

    public String message() {
        return this.message;
    }

    public int hashCode() {
        return Objects.hash(this.node);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Failure other = (Failure)obj;
        return Objects.equals(this.node, other.node);
    }

    public String toString() {
        return this.message;
    }

    public static Failure fail(Node<?> source, String message, Object ... args) {
        return new Failure(source, LoggerMessageFormat.format(message, args));
    }

    public static String failMessage(Collection<Failure> failures) {
        return failures.stream().map(f -> {
            Location l = f.node().source().source();
            return "line " + l.getLineNumber() + ":" + l.getColumnNumber() + ": " + f.message();
        }).collect(Collectors.joining("\n", LoggerMessageFormat.format("Found {} problem{}\n", failures.size(), failures.size() > 1 ? "s" : ""), ""));
    }
}

