/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression;

import java.util.Objects;
import org.elasticsearch.common.Strings;
import org.elasticsearch.xpack.ql.expression.Attribute;
import org.elasticsearch.xpack.ql.expression.NameId;
import org.elasticsearch.xpack.ql.expression.Nullability;
import org.elasticsearch.xpack.ql.expression.TypedAttribute;
import org.elasticsearch.xpack.ql.tree.NodeInfo;
import org.elasticsearch.xpack.ql.tree.Source;
import org.elasticsearch.xpack.ql.type.DataType;
import org.elasticsearch.xpack.ql.type.DataTypes;
import org.elasticsearch.xpack.ql.type.EsField;

public class FieldAttribute
extends TypedAttribute {
    private final FieldAttribute parent;
    private final FieldAttribute nestedParent;
    private final String path;
    private final EsField field;

    public FieldAttribute(Source source, String name, EsField field) {
        this(source, null, name, field);
    }

    public FieldAttribute(Source source, FieldAttribute parent, String name, EsField field) {
        this(source, parent, name, field, null, Nullability.TRUE, null, false);
    }

    public FieldAttribute(Source source, FieldAttribute parent, String name, EsField field, String qualifier, Nullability nullability, NameId id, boolean synthetic) {
        this(source, parent, name, field.getDataType(), field, qualifier, nullability, id, synthetic);
    }

    public FieldAttribute(Source source, FieldAttribute parent, String name, DataType type, EsField field, String qualifier, Nullability nullability, NameId id, boolean synthetic) {
        super(source, name, type, qualifier, nullability, id, synthetic);
        this.path = parent != null ? parent.name() : "";
        this.parent = parent;
        this.field = field;
        FieldAttribute nestedPar = null;
        if (parent != null) {
            nestedPar = parent.nestedParent;
            if (parent.dataType() == DataTypes.NESTED) {
                nestedPar = parent;
            }
        }
        this.nestedParent = nestedPar;
    }

    @Override
    protected NodeInfo<FieldAttribute> info() {
        return NodeInfo.create(this, FieldAttribute::new, this.parent, this.name(), this.dataType(), this.field, this.qualifier(), this.nullable(), this.id(), this.synthetic());
    }

    public FieldAttribute parent() {
        return this.parent;
    }

    public String path() {
        return this.path;
    }

    public String qualifiedPath() {
        return this.qualifier() != null ? this.qualifier() + (Strings.hasText(this.path) ? "." + this.path : "") : this.path;
    }

    public boolean isNested() {
        return this.nestedParent != null;
    }

    public FieldAttribute nestedParent() {
        return this.nestedParent;
    }

    public EsField.Exact getExactInfo() {
        return this.field.getExactInfo();
    }

    public FieldAttribute exactAttribute() {
        EsField exactField = this.field.getExactField();
        if (!exactField.equals(this.field)) {
            return this.innerField(exactField);
        }
        return this;
    }

    private FieldAttribute innerField(EsField type) {
        return new FieldAttribute(this.source(), this, this.name() + "." + type.getName(), type, this.qualifier(), this.nullable(), this.id(), this.synthetic());
    }

    @Override
    protected Attribute clone(Source source, String name, DataType type, String qualifier, Nullability nullability, NameId id, boolean synthetic) {
        FieldAttribute qualifiedParent = this.parent != null ? (FieldAttribute)this.parent.withQualifier(qualifier) : null;
        return new FieldAttribute(source, qualifiedParent, name, this.field, qualifier, nullability, id, synthetic);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.path);
    }

    @Override
    public boolean equals(Object obj) {
        return super.equals(obj) && Objects.equals(this.path, ((FieldAttribute)obj).path);
    }

    @Override
    protected String label() {
        return "f";
    }

    public EsField field() {
        return this.field;
    }
}

