/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.gen.processor;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.xpack.ql.QlIllegalArgumentException;
import org.elasticsearch.xpack.ql.execution.search.extractor.HitExtractor;
import org.elasticsearch.xpack.ql.expression.gen.processor.Processor;

public class HitExtractorProcessor
implements Processor {
    public static final String NAME = "h";
    private final HitExtractor extractor;

    public HitExtractorProcessor(HitExtractor extractor) {
        this.extractor = extractor;
    }

    public HitExtractorProcessor(StreamInput in) throws IOException {
        this.extractor = in.readNamedWriteable(HitExtractor.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeNamedWriteable(this.extractor);
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }

    @Override
    public Object process(Object input) {
        if (!(input instanceof SearchHit)) {
            throw new QlIllegalArgumentException("Expected a SearchHit but received {}", input);
        }
        return this.extractor.extract((SearchHit)input);
    }

    public int hashCode() {
        return Objects.hash(this.extractor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        HitExtractorProcessor other = (HitExtractorProcessor)obj;
        return Objects.equals(this.extractor, other.extractor);
    }

    public String toString() {
        return this.extractor.toString();
    }
}

