/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.master.TransportMasterNodeReadAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.license.GetBasicStatusRequest;
import org.elasticsearch.license.GetBasicStatusResponse;
import org.elasticsearch.license.License;
import org.elasticsearch.license.LicensesMetadata;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportGetBasicStatusAction
extends TransportMasterNodeReadAction<GetBasicStatusRequest, GetBasicStatusResponse> {
    @Inject
    public TransportGetBasicStatusAction(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super("cluster:admin/xpack/license/basic_status", transportService, clusterService, threadPool, actionFilters, GetBasicStatusRequest::new, indexNameExpressionResolver, GetBasicStatusResponse::new, "same");
    }

    protected void masterOperation(GetBasicStatusRequest request, ClusterState state, ActionListener<GetBasicStatusResponse> listener) throws Exception {
        LicensesMetadata licensesMetadata = (LicensesMetadata)state.metadata().custom("licenses");
        if (licensesMetadata == null) {
            listener.onResponse((Object)new GetBasicStatusResponse(true));
        } else {
            License license = licensesMetadata.getLicense();
            listener.onResponse((Object)new GetBasicStatusResponse(license == null || !License.LicenseType.isBasic(license.type())));
        }
    }

    protected ClusterBlockException checkBlock(GetBasicStatusRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_READ);
    }
}

