/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.datastreams;

import java.util.Objects;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.xpack.core.action.CreateDataStreamAction;
import org.elasticsearch.xpack.core.action.DataStreamsStatsAction;
import org.elasticsearch.xpack.core.action.DeleteDataStreamAction;
import org.elasticsearch.xpack.core.action.GetDataStreamAction;

public class DataStreamClient {
    private final ElasticsearchClient client;

    public DataStreamClient(ElasticsearchClient client) {
        this.client = Objects.requireNonNull(client);
    }

    public void createDataStream(CreateDataStreamAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute((ActionType)CreateDataStreamAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<AcknowledgedResponse> createDataStream(CreateDataStreamAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)CreateDataStreamAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }

    public void getDataStream(GetDataStreamAction.Request request, ActionListener<GetDataStreamAction.Response> listener) {
        this.client.execute((ActionType)GetDataStreamAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<GetDataStreamAction.Response> getDataStream(GetDataStreamAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)GetDataStreamAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }

    public void deleteDataStream(DeleteDataStreamAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute((ActionType)DeleteDataStreamAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<AcknowledgedResponse> deleteDataStream(DeleteDataStreamAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)DeleteDataStreamAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }

    public void dataStreamsStats(DataStreamsStatsAction.Request request, ActionListener<DataStreamsStatsAction.Response> listener) {
        this.client.execute((ActionType)DataStreamsStatsAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<DataStreamsStatsAction.Response> dataStreamsStats(DataStreamsStatsAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)DataStreamsStatsAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }
}

