/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.enrich.client;

import java.util.Objects;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.xpack.core.enrich.action.DeleteEnrichPolicyAction;
import org.elasticsearch.xpack.core.enrich.action.ExecuteEnrichPolicyAction;
import org.elasticsearch.xpack.core.enrich.action.GetEnrichPolicyAction;
import org.elasticsearch.xpack.core.enrich.action.PutEnrichPolicyAction;

public class EnrichClient {
    private final ElasticsearchClient client;

    public EnrichClient(ElasticsearchClient client) {
        this.client = Objects.requireNonNull(client, "client");
    }

    public void deleteEnrichPolicy(DeleteEnrichPolicyAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute((ActionType)DeleteEnrichPolicyAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<AcknowledgedResponse> deleteEnrichPolicy(DeleteEnrichPolicyAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)DeleteEnrichPolicyAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }

    public void executeEnrichPolicy(ExecuteEnrichPolicyAction.Request request, ActionListener<ExecuteEnrichPolicyAction.Response> listener) {
        this.client.execute((ActionType)ExecuteEnrichPolicyAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<ExecuteEnrichPolicyAction.Response> executeEnrichPolicy(ExecuteEnrichPolicyAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)ExecuteEnrichPolicyAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }

    public void getEnrichPolicy(GetEnrichPolicyAction.Request request, ActionListener<GetEnrichPolicyAction.Response> listener) {
        this.client.execute((ActionType)GetEnrichPolicyAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<GetEnrichPolicyAction.Response> getEnrichPolicy(GetEnrichPolicyAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)GetEnrichPolicyAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }

    public void putEnrichPolicy(PutEnrichPolicyAction.Request request, ActionListener<AcknowledgedResponse> listener) {
        this.client.execute((ActionType)PutEnrichPolicyAction.INSTANCE, (ActionRequest)request, listener);
    }

    public ActionFuture<AcknowledgedResponse> putEnrichPolicy(PutEnrichPolicyAction.Request request) {
        PlainActionFuture listener = PlainActionFuture.newFuture();
        this.client.execute((ActionType)PutEnrichPolicyAction.INSTANCE, (ActionRequest)request, (ActionListener)listener);
        return listener;
    }
}

