/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.xpack.core.ilm.AsyncRetryDuringSnapshotActionStep;
import org.elasticsearch.xpack.core.ilm.LifecycleExecutionState;
import org.elasticsearch.xpack.core.ilm.ShrinkIndexNameSupplier;
import org.elasticsearch.xpack.core.ilm.Step;
import org.elasticsearch.xpack.core.ilm.SwapAliasesAndDeleteSourceIndexStep;

public class ShrinkSetAliasStep
extends AsyncRetryDuringSnapshotActionStep {
    public static final String NAME = "aliases";

    public ShrinkSetAliasStep(Step.StepKey key, Step.StepKey nextStepKey, Client client) {
        super(key, nextStepKey, client);
    }

    @Override
    public boolean isRetryable() {
        return true;
    }

    @Override
    public void performDuringNoSnapshot(IndexMetadata indexMetadata, ClusterState currentState, ActionListener<Void> listener) {
        String indexName = indexMetadata.getIndex().getName();
        LifecycleExecutionState lifecycleState = LifecycleExecutionState.fromIndexMetadata(indexMetadata);
        String targetIndexName = ShrinkIndexNameSupplier.getShrinkIndexName(indexName, lifecycleState);
        SwapAliasesAndDeleteSourceIndexStep.deleteSourceIndexAndTransferAliases(this.getClient(), indexMetadata, targetIndexName, listener);
    }

    @Override
    public boolean indexSurvives() {
        return false;
    }
}

