/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.TargetType;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble.LenientlyParsedOutputAggregator;
import org.elasticsearch.xpack.core.ml.inference.trainedmodel.ensemble.StrictlyParsedOutputAggregator;

public class WeightedSum
implements StrictlyParsedOutputAggregator,
LenientlyParsedOutputAggregator {
    private static final long SHALLOW_SIZE = RamUsageEstimator.shallowSizeOfInstance(WeightedSum.class);
    public static final ParseField NAME = new ParseField("weighted_sum", new String[0]);
    public static final ParseField WEIGHTS = new ParseField("weights", new String[0]);
    private static final ConstructingObjectParser<WeightedSum, Void> LENIENT_PARSER = WeightedSum.createParser(true);
    private static final ConstructingObjectParser<WeightedSum, Void> STRICT_PARSER = WeightedSum.createParser(false);
    private final double[] weights;

    private static ConstructingObjectParser<WeightedSum, Void> createParser(boolean lenient) {
        ConstructingObjectParser parser = new ConstructingObjectParser(NAME.getPreferredName(), lenient, a -> new WeightedSum((List)a[0]));
        parser.declareDoubleArray(ConstructingObjectParser.optionalConstructorArg(), WEIGHTS);
        return parser;
    }

    public static WeightedSum fromXContentStrict(XContentParser parser) {
        return (WeightedSum)STRICT_PARSER.apply(parser, null);
    }

    public static WeightedSum fromXContentLenient(XContentParser parser) {
        return (WeightedSum)LENIENT_PARSER.apply(parser, null);
    }

    WeightedSum() {
        this((List<Double>)null);
    }

    private WeightedSum(List<Double> weights) {
        this(weights == null ? null : weights.stream().mapToDouble(Double::valueOf).toArray());
    }

    public WeightedSum(double[] weights) {
        this.weights = weights;
    }

    public WeightedSum(StreamInput in) throws IOException {
        this.weights = (double[])(in.readBoolean() ? in.readDoubleArray() : null);
    }

    @Override
    public double[] processValues(double[][] values) {
        Objects.requireNonNull(values, "values must not be null");
        assert (values[0].length == 1);
        if (this.weights == null) {
            return Arrays.stream(values).mapToDouble(v -> v[0]).toArray();
        }
        if (values.length != this.weights.length) {
            throw new IllegalArgumentException("values must be the same length as weights.");
        }
        return IntStream.range(0, this.weights.length).mapToDouble(i -> values[i][0] * this.weights[i]).toArray();
    }

    @Override
    public double aggregate(double[] values) {
        Objects.requireNonNull(values, "values must not be null");
        if (values.length == 0) {
            throw new IllegalArgumentException("values must not be empty");
        }
        return Arrays.stream(values).sum();
    }

    @Override
    public String getName() {
        return NAME.getPreferredName();
    }

    public String getWriteableName() {
        return NAME.getPreferredName();
    }

    public void writeTo(StreamOutput out) throws IOException {
        out.writeBoolean(this.weights != null);
        if (this.weights != null) {
            out.writeDoubleArray(this.weights);
        }
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        if (this.weights != null) {
            builder.field(WEIGHTS.getPreferredName(), (Object)this.weights);
        }
        builder.endObject();
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WeightedSum that = (WeightedSum)o;
        return Arrays.equals(this.weights, that.weights);
    }

    public int hashCode() {
        return Arrays.hashCode(this.weights);
    }

    @Override
    public Integer expectedValueSize() {
        return this.weights == null ? null : Integer.valueOf(this.weights.length);
    }

    @Override
    public boolean compatibleWith(TargetType targetType) {
        return TargetType.REGRESSION.equals((Object)targetType);
    }

    public long ramBytesUsed() {
        long weightSize = this.weights == null ? 0L : RamUsageEstimator.sizeOf((double[])this.weights);
        return SHALLOW_SIZE + weightSize;
    }
}

