/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.searchablesnapshots;

import java.util.Map;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.index.IndexModule;

public class SearchableSnapshotsConstants {
    public static final Setting<Boolean> SNAPSHOT_PARTIAL_SETTING = Setting.boolSetting((String)"index.store.snapshot.partial", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.IndexScope, Setting.Property.PrivateIndex, Setting.Property.NotCopyableOnResize});

    public static boolean isPartialSearchableSnapshotIndex(Map<Setting<?>, Object> indexSettings) {
        assert (indexSettings.containsKey(IndexModule.INDEX_STORE_TYPE_SETTING)) : "must include store type in map";
        assert (indexSettings.get(SNAPSHOT_PARTIAL_SETTING) != null) : "partial setting must be non-null in map (has default value)";
        return "snapshot".equals(indexSettings.get(IndexModule.INDEX_STORE_TYPE_SETTING)) && (Boolean)indexSettings.get(SNAPSHOT_PARTIAL_SETTING) != false;
    }
}

