/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.ql.expression.predicate;

import java.util.Objects;
import org.elasticsearch.xpack.ql.expression.Expression;
import org.elasticsearch.xpack.ql.expression.function.scalar.BinaryScalarFunction;
import org.elasticsearch.xpack.ql.expression.predicate.PredicateBiFunction;
import org.elasticsearch.xpack.ql.tree.Source;

public abstract class BinaryPredicate<T, U, R, F extends PredicateBiFunction<T, U, R>>
extends BinaryScalarFunction {
    private final F function;

    protected BinaryPredicate(Source source, Expression left, Expression right, F function) {
        super(source, left, right);
        this.function = function;
    }

    public R fold() {
        return this.function().apply((Object)this.left().fold(), (Object)this.right().fold());
    }

    @Override
    protected String scriptMethodName() {
        return this.function.scriptMethodName();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.left(), this.right(), this.function.symbol());
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BinaryPredicate other = (BinaryPredicate)obj;
        return Objects.equals(this.symbol(), other.symbol()) && Objects.equals(this.left(), other.left()) && Objects.equals(this.right(), other.right());
    }

    public String symbol() {
        return this.function.symbol();
    }

    public F function() {
        return this.function;
    }

    @Override
    public String nodeString() {
        return this.left().nodeString() + " " + this.symbol() + " " + this.right().nodeString();
    }
}

