/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.deprecation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentElasticsearchExtension;
import org.elasticsearch.core.Map;
import org.elasticsearch.xpack.core.XPackSettings;
import org.elasticsearch.xpack.core.action.util.PageParams;
import org.elasticsearch.xpack.core.ml.action.GetDatafeedsAction;
import org.elasticsearch.xpack.core.ml.action.GetModelSnapshotsAction;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;
import org.elasticsearch.xpack.core.ml.job.process.autodetect.state.ModelSnapshot;
import org.elasticsearch.xpack.deprecation.DeprecationChecker;
import org.elasticsearch.xpack.deprecation.DeprecationIssue;

public class MlDeprecationChecker
implements DeprecationChecker {
    static Optional<DeprecationIssue> checkDataFeedQuery(DatafeedConfig datafeedConfig, NamedXContentRegistry xContentRegistry) {
        List deprecations = datafeedConfig.getQueryDeprecations(xContentRegistry);
        if (deprecations.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DeprecationIssue(DeprecationIssue.Level.WARNING, "Datafeed [" + datafeedConfig.getId() + "] uses deprecated query options", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-7.0.html#breaking_70_search_changes", deprecations.toString(), false, null));
    }

    static Optional<DeprecationIssue> checkDataFeedAggregations(DatafeedConfig datafeedConfig, NamedXContentRegistry xContentRegistry) {
        List deprecations = datafeedConfig.getAggDeprecations(xContentRegistry);
        if (deprecations.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new DeprecationIssue(DeprecationIssue.Level.WARNING, "Datafeed [" + datafeedConfig.getId() + "] uses deprecated aggregation options", "https://www.elastic.co/guide/en/elasticsearch/reference/master/breaking-changes-7.0.html#breaking_70_aggregations_changes", deprecations.toString(), false, null));
    }

    static Optional<DeprecationIssue> checkModelSnapshot(ModelSnapshot modelSnapshot) {
        if (modelSnapshot.getMinVersion().before(Version.V_7_0_0)) {
            StringBuilder details = new StringBuilder(String.format(Locale.ROOT, "model snapshot [%s] for job [%s] supports minimum version [%s] and needs to be at least [%s].", modelSnapshot.getSnapshotId(), modelSnapshot.getJobId(), modelSnapshot.getMinVersion(), Version.V_7_0_0));
            if (modelSnapshot.getLatestRecordTimeStamp() != null) {
                details.append(String.format(Locale.ROOT, " The model snapshot's latest record timestamp is [%s]", XContentElasticsearchExtension.DEFAULT_DATE_PRINTER.print(modelSnapshot.getLatestRecordTimeStamp().getTime())));
            }
            return Optional.of(new DeprecationIssue(DeprecationIssue.Level.CRITICAL, String.format(Locale.ROOT, "model snapshot [%s] for job [%s] needs to be deleted or upgraded", modelSnapshot.getSnapshotId(), modelSnapshot.getJobId()), "https://www.elastic.co/guide/en/elasticsearch/reference/master/ml-upgrade-job-model-snapshot.html", details.toString(), false, Map.of((Object)"job_id", (Object)modelSnapshot.getJobId(), (Object)"snapshot_id", (Object)modelSnapshot.getSnapshotId())));
        }
        return Optional.empty();
    }

    @Override
    public boolean enabled(Settings settings) {
        return (Boolean)XPackSettings.MACHINE_LEARNING_ENABLED.get(settings);
    }

    @Override
    public void check(DeprecationChecker.Components components, ActionListener<DeprecationChecker.CheckResult> deprecationIssueListener) {
        if (!((Boolean)XPackSettings.MACHINE_LEARNING_ENABLED.get(components.settings())).booleanValue()) {
            deprecationIssueListener.onResponse((Object)new DeprecationChecker.CheckResult(this.getName(), Collections.emptyList()));
            return;
        }
        List issues = Collections.synchronizedList(new ArrayList());
        GetModelSnapshotsAction.Request getModelSnapshots = new GetModelSnapshotsAction.Request("*", null);
        getModelSnapshots.setPageParams(new PageParams(0, 50));
        getModelSnapshots.setSort(ModelSnapshot.MIN_VERSION.getPreferredName());
        ActionListener getModelSnaphots = ActionListener.wrap(_unused -> components.client().execute((ActionType)GetModelSnapshotsAction.INSTANCE, (ActionRequest)getModelSnapshots, ActionListener.wrap(modelSnapshots -> {
            modelSnapshots.getResources().results().forEach(modelSnapshot -> MlDeprecationChecker.checkModelSnapshot(modelSnapshot).ifPresent(issues::add));
            deprecationIssueListener.onResponse((Object)new DeprecationChecker.CheckResult(this.getName(), issues));
        }, arg_0 -> ((ActionListener)deprecationIssueListener).onFailure(arg_0))), arg_0 -> deprecationIssueListener.onFailure(arg_0));
        components.client().execute((ActionType)GetDatafeedsAction.INSTANCE, (ActionRequest)new GetDatafeedsAction.Request("_all"), ActionListener.wrap(datafeedsResponse -> {
            for (DatafeedConfig df : datafeedsResponse.getResponse().results()) {
                MlDeprecationChecker.checkDataFeedAggregations(df, components.xContentRegistry()).ifPresent(issues::add);
                MlDeprecationChecker.checkDataFeedQuery(df, components.xContentRegistry()).ifPresent(issues::add);
            }
            getModelSnaphots.onResponse(null);
        }, arg_0 -> deprecationIssueListener.onFailure(arg_0)));
    }

    @Override
    public String getName() {
        return "ml_settings";
    }
}

