/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.collector.node;

import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.admin.cluster.node.stats.NodeStats;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsRequest;
import org.elasticsearch.action.admin.cluster.node.stats.NodesStatsResponse;
import org.elasticsearch.action.admin.indices.stats.CommonStatsFlags;
import org.elasticsearch.bootstrap.BootstrapInfo;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.license.XPackLicenseState;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.collector.Collector;
import org.elasticsearch.xpack.monitoring.collector.TimeoutUtils;
import org.elasticsearch.xpack.monitoring.collector.node.NodeStatsMonitoringDoc;

public class NodeStatsCollector
extends Collector {
    public static final Setting<TimeValue> NODE_STATS_TIMEOUT = NodeStatsCollector.collectionTimeoutSetting("node.stats.timeout");
    private static final CommonStatsFlags FLAGS = new CommonStatsFlags(new CommonStatsFlags.Flag[]{CommonStatsFlags.Flag.Docs, CommonStatsFlags.Flag.FieldData, CommonStatsFlags.Flag.Store, CommonStatsFlags.Flag.Indexing, CommonStatsFlags.Flag.QueryCache, CommonStatsFlags.Flag.RequestCache, CommonStatsFlags.Flag.Search, CommonStatsFlags.Flag.Segments});
    private final Client client;

    public NodeStatsCollector(ClusterService clusterService, XPackLicenseState licenseState, Client client) {
        super("node_stats", clusterService, NODE_STATS_TIMEOUT, licenseState);
        this.client = Objects.requireNonNull(client);
    }

    @Override
    protected boolean shouldCollect(boolean isElectedMaster) {
        return super.shouldCollect(isElectedMaster);
    }

    @Override
    protected Collection<MonitoringDoc> doCollect(MonitoringDoc.Node node, long interval, ClusterState clusterState) {
        NodesStatsRequest request = new NodesStatsRequest(new String[]{"_local"});
        request.indices(FLAGS);
        request.addMetrics(new String[]{NodesStatsRequest.Metric.OS.metricName(), NodesStatsRequest.Metric.JVM.metricName(), NodesStatsRequest.Metric.PROCESS.metricName(), NodesStatsRequest.Metric.THREAD_POOL.metricName(), NodesStatsRequest.Metric.FS.metricName()});
        request.timeout(this.getCollectionTimeout());
        NodesStatsResponse response = (NodesStatsResponse)this.client.admin().cluster().nodesStats(request).actionGet();
        TimeoutUtils.ensureNoTimeouts(this.getCollectionTimeout(), response);
        if (response.hasFailures()) {
            throw (FailedNodeException)response.failures().get(0);
        }
        String clusterUuid = NodeStatsCollector.clusterUuid(clusterState);
        NodeStats nodeStats = (NodeStats)response.getNodes().get(0);
        return Collections.singletonList(new NodeStatsMonitoringDoc(clusterUuid, nodeStats.getTimestamp(), interval, node, node.getUUID(), clusterState.getNodes().isLocalNodeElectedMaster(), nodeStats, BootstrapInfo.isMemoryLocked()));
    }
}

