/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter;

import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.xpack.core.monitoring.MonitoredSystem;
import org.elasticsearch.xpack.core.monitoring.exporter.MonitoringDoc;

public class BytesReferenceMonitoringDoc
extends MonitoringDoc {
    private final XContentType xContentType;
    private final BytesReference source;

    public BytesReferenceMonitoringDoc(String cluster, long timestamp, long intervalMillis, @Nullable MonitoringDoc.Node node, MonitoredSystem system, String type, @Nullable String id, XContentType xContentType, BytesReference source) {
        super(cluster, timestamp, intervalMillis, node, system, type, id);
        this.xContentType = Objects.requireNonNull(xContentType);
        this.source = Objects.requireNonNull(source);
    }

    XContentType getXContentType() {
        return this.xContentType;
    }

    BytesReference getSource() {
        return this.source;
    }

    protected void innerToXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.source.length() > 0) {
            try (StreamInput stream = this.source.streamInput();){
                builder.rawField(this.getType(), (InputStream)stream, this.xContentType);
            }
        } else {
            builder.nullField(this.getType());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BytesReferenceMonitoringDoc that = (BytesReferenceMonitoringDoc)((Object)o);
        return this.xContentType == that.xContentType && Objects.equals(this.source, that.source);
    }

    public int hashCode() {
        return Objects.hash(super.hashCode(), this.xContentType, this.source);
    }
}

