/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.util.set.Sets;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.CheckedFunction;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.MultiHttpResource;
import org.elasticsearch.xpack.monitoring.exporter.http.PublishableHttpResource;

public class WatcherExistsHttpResource
extends PublishableHttpResource {
    private static final Logger logger = LogManager.getLogger(WatcherExistsHttpResource.class);
    public static final Map<String, String> WATCHER_CHECK_PARAMETERS = Collections.singletonMap("filter_path", "features.watcher.available,features.watcher.enabled");
    public static final Set<Integer> XPACK_DOES_NOT_EXIST = Sets.newHashSet((Object[])new Integer[]{RestStatus.NOT_FOUND.getStatus(), RestStatus.BAD_REQUEST.getStatus()});
    private final ClusterService clusterService;
    private final MultiHttpResource watches;

    public WatcherExistsHttpResource(String resourceOwnerName, ClusterService clusterService, MultiHttpResource watches) {
        super(resourceOwnerName, null, WATCHER_CHECK_PARAMETERS);
        this.clusterService = Objects.requireNonNull(clusterService);
        this.watches = Objects.requireNonNull(watches);
    }

    public MultiHttpResource getWatches() {
        return this.watches;
    }

    @Override
    protected void doCheck(RestClient client, ActionListener<Boolean> listener) {
        if (this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            this.checkXPackForWatcher(client, listener);
        } else {
            listener.onResponse((Object)true);
        }
    }

    private void checkXPackForWatcher(RestClient client, ActionListener<Boolean> listener) {
        CheckedFunction responseChecker = response -> this.canUseWatcher((Response)response, XContentType.JSON.xContent());
        CheckedFunction doesNotExistChecker = response -> false;
        this.checkForResource(client, listener, logger, "", "_xpack", "watcher check", this.resourceOwnerName, "monitoring cluster", GET_EXISTS, Sets.newHashSet((Object[])new Integer[]{RestStatus.NOT_FOUND.getStatus(), RestStatus.BAD_REQUEST.getStatus()}), (CheckedFunction<Response, Boolean, IOException>)responseChecker, (CheckedFunction<Response, Boolean, IOException>)doesNotExistChecker);
    }

    private boolean canUseWatcher(Response response, XContent xContent) throws IOException {
        Map xpackInfo = XContentHelper.convertToMap((XContent)xContent, (InputStream)response.getEntity().getContent(), (boolean)false);
        if (!xpackInfo.isEmpty()) {
            Map features = (Map)xpackInfo.get("features");
            Map watcher = (Map)features.get("watcher");
            return Boolean.TRUE == watcher.get("available") && Boolean.TRUE == watcher.get("enabled");
        }
        return false;
    }

    @Override
    protected void doPublish(RestClient client, ActionListener<HttpResource.ResourcePublishResult> listener) {
        this.watches.checkAndPublish(client, listener);
    }
}

