/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.idp.saml.sp;

import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.ParsingException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.cache.Cache;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.iterable.Iterables;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentLocation;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.Environment;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.core.XPackPlugin;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProvider;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderDocument;
import org.elasticsearch.xpack.idp.saml.sp.SamlServiceProviderFactory;
import org.elasticsearch.xpack.idp.saml.sp.ServiceProviderCacheSettings;
import org.elasticsearch.xpack.idp.saml.sp.WildcardServiceProvider;

public class WildcardServiceProviderResolver {
    public static final Setting<String> FILE_PATH_SETTING = Setting.simpleString((String)"xpack.idp.sp.wildcard.path", (String)"wildcard_services.json", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private static final Logger logger = LogManager.getLogger();
    private final Settings settings;
    private final ScriptService scriptService;
    private final SamlServiceProviderFactory serviceProviderFactory;
    private final AtomicReference<State> stateRef;

    WildcardServiceProviderResolver(Settings settings, ScriptService scriptService, SamlServiceProviderFactory serviceProviderFactory) {
        this.settings = settings;
        this.scriptService = scriptService;
        this.serviceProviderFactory = serviceProviderFactory;
        this.stateRef = new AtomicReference<State>(new State(Collections.emptyMap()));
    }

    public static WildcardServiceProviderResolver create(Environment environment, ResourceWatcherService resourceWatcherService, ScriptService scriptService, SamlServiceProviderFactory spFactory) {
        Settings settings = environment.settings();
        Path path = XPackPlugin.resolveConfigFile((Environment)environment, (String)((String)FILE_PATH_SETTING.get(environment.settings())));
        logger.info("Loading wildcard services from file [{}]", (Object)path.toAbsolutePath());
        final WildcardServiceProviderResolver resolver = new WildcardServiceProviderResolver(settings, scriptService, spFactory);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                resolver.reload(path);
            }
            catch (IOException e) {
                throw new ElasticsearchException("File [{}] (from setting [{}]) cannot be loaded", (Throwable)e, new Object[]{path.toAbsolutePath(), FILE_PATH_SETTING.getKey()});
            }
        } else if (FILE_PATH_SETTING.exists(environment.settings())) {
            throw new ElasticsearchException("File [{}] (from setting [{}]) does not exist", new Object[]{path.toAbsolutePath(), FILE_PATH_SETTING.getKey()});
        }
        FileWatcher fileWatcher = new FileWatcher(path);
        fileWatcher.addListener((Object)new FileChangesListener(){

            public void onFileCreated(Path file) {
                this.onFileChanged(file);
            }

            public void onFileDeleted(Path file) {
                this.onFileChanged(file);
            }

            public void onFileChanged(Path file) {
                try {
                    resolver.reload(file);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
        });
        try {
            resourceWatcherService.add((ResourceWatcher)fileWatcher);
        }
        catch (IOException e) {
            throw new ElasticsearchException("Failed to watch file [{}] (from setting [{}])", (Throwable)e, new Object[]{path.toAbsolutePath(), FILE_PATH_SETTING.getKey()});
        }
        return resolver;
    }

    public SamlServiceProvider resolve(String entityId, String acs) {
        State currentState = this.stateRef.get();
        Tuple cacheKey = new Tuple((Object)entityId, (Object)acs);
        SamlServiceProvider cached = (SamlServiceProvider)currentState.cache.get((Object)cacheKey);
        if (cached != null) {
            logger.trace("Service for [{}] [{}] is cached [{}]", (Object)entityId, (Object)acs, (Object)cached);
            return cached;
        }
        HashMap matches = new HashMap();
        currentState.services.forEach((name, wildcard) -> {
            SamlServiceProviderDocument doc = wildcard.apply(this.scriptService, entityId, acs);
            if (doc != null) {
                SamlServiceProvider sp = this.serviceProviderFactory.buildServiceProvider(doc);
                matches.put(name, sp);
            }
        });
        switch (matches.size()) {
            case 0: {
                logger.trace("No wildcard services found for [{}] [{}]", (Object)entityId, (Object)acs);
                return null;
            }
            case 1: {
                SamlServiceProvider serviceProvider = (SamlServiceProvider)Iterables.get(matches.values(), (int)0);
                logger.trace("Found exactly 1 wildcard service for [{}] [{}] - [{}]", (Object)entityId, (Object)acs, (Object)serviceProvider);
                currentState.cache.put((Object)cacheKey, (Object)serviceProvider);
                return serviceProvider;
            }
        }
        String names = Strings.collectionToCommaDelimitedString(matches.keySet());
        logger.warn("Found multiple matching wildcard services for [{}] [{}] - [{}]", (Object)entityId, (Object)acs, (Object)names);
        throw new IllegalStateException("Found multiple wildcard service providers for entity ID [" + entityId + "] and ACS [" + acs + "] - wildcard service names [" + names + "]");
    }

    Map<String, WildcardServiceProvider> services() {
        return this.stateRef.get().services;
    }

    void reload(XContentParser parser) throws IOException {
        Map<String, WildcardServiceProvider> newServices = Collections.unmodifiableMap(WildcardServiceProviderResolver.parse(parser));
        State oldState = this.stateRef.get();
        if (!newServices.equals(oldState.services) && this.stateRef.compareAndSet(oldState, new State(newServices))) {
            logger.info("Reloaded cached wildcard service providers, new providers [{}]", (Object)Strings.collectionToCommaDelimitedString(newServices.keySet()));
        }
    }

    private void reload(Path file) throws IOException {
        try (InputStream in = Files.newInputStream(file, new OpenOption[0]);
             XContentParser parser = WildcardServiceProviderResolver.buildServicesParser(in);){
            this.reload(parser);
        }
    }

    private static XContentParser buildServicesParser(InputStream in) throws IOException {
        return XContentType.JSON.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, in);
    }

    private static Map<String, WildcardServiceProvider> parse(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken() == null ? parser.nextToken() : parser.currentToken();
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)token, (XContentParser)parser);
        XContentParserUtils.ensureFieldName((XContentParser)parser, (XContentParser.Token)parser.nextToken(), (String)Fields.SERVICES.getPreferredName());
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.START_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        HashMap<String, WildcardServiceProvider> services = new HashMap<String, WildcardServiceProvider>();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.FIELD_NAME, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
            String name = parser.currentName();
            XContentLocation location = parser.getTokenLocation();
            try {
                services.put(name, WildcardServiceProvider.parse(parser));
            }
            catch (Exception e) {
                throw new ParsingException(location, "failed to parse wildcard service [{}]", (Throwable)e, new Object[]{name});
            }
        }
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.currentToken(), (XContentParser)parser);
        XContentParserUtils.ensureExpectedToken((XContentParser.Token)XContentParser.Token.END_OBJECT, (XContentParser.Token)parser.nextToken(), (XContentParser)parser);
        return services;
    }

    public static Collection<? extends Setting<?>> getSettings() {
        return Collections.singletonList(FILE_PATH_SETTING);
    }

    private class State {
        final Map<String, WildcardServiceProvider> services;
        final Cache<Tuple<String, String>, SamlServiceProvider> cache;

        private State(Map<String, WildcardServiceProvider> services) {
            this.services = services;
            this.cache = ServiceProviderCacheSettings.buildCache(WildcardServiceProviderResolver.this.settings);
        }
    }

    public static interface Fields {
        public static final ParseField SERVICES = new ParseField("services", new String[0]);
    }
}

