/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.support.tasks.BaseTasksResponse;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.xpack.core.ml.action.JobTaskRequest;

public class PersistJobAction
extends Action<Request, Response, RequestBuilder> {
    public static final PersistJobAction INSTANCE = new PersistJobAction();
    public static final String NAME = "cluster:admin/xpack/ml/job/persist";

    private PersistJobAction() {
        super(NAME);
    }

    public RequestBuilder newRequestBuilder(ElasticsearchClient client) {
        return new RequestBuilder(client, this);
    }

    public Response newResponse() {
        return new Response();
    }

    static class RequestBuilder
    extends ActionRequestBuilder<Request, Response, RequestBuilder> {
        RequestBuilder(ElasticsearchClient client, PersistJobAction action) {
            super(client, (Action)action, (ActionRequest)new Request());
        }
    }

    public static class Response
    extends BaseTasksResponse
    implements Writeable {
        boolean persisted;

        public Response() {
            super(null, null);
        }

        public Response(boolean persisted) {
            super(null, null);
            this.persisted = persisted;
        }

        public boolean isPersisted() {
            return this.persisted;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.persisted = in.readBoolean();
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(this.persisted);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response that = (Response)((Object)o);
            return this.persisted == that.persisted;
        }

        public int hashCode() {
            return Objects.hash(this.persisted);
        }
    }

    public static class Request
    extends JobTaskRequest<Request> {
        public Request() {
        }

        public Request(String jobId) {
            super(jobId);
        }

        public boolean isBackGround() {
            return true;
        }

        public boolean isForeground() {
            return !this.isBackGround();
        }

        @Override
        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            in.readBoolean();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeBoolean(true);
        }

        public int hashCode() {
            return Objects.hash(this.jobId, this.isBackGround());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || ((Object)((Object)this)).getClass() != obj.getClass()) {
                return false;
            }
            Request other = (Request)((Object)obj);
            return Objects.equals(this.jobId, other.jobId) && this.isBackGround() == other.isBackGround();
        }
    }
}

