/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.action.user;

import java.io.IOException;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.client.ElasticsearchClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesAction;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesRequest;
import org.elasticsearch.xpack.core.security.action.user.HasPrivilegesResponse;
import org.elasticsearch.xpack.core.security.authz.RoleDescriptor;

public class HasPrivilegesRequestBuilder
extends ActionRequestBuilder<HasPrivilegesRequest, HasPrivilegesResponse, HasPrivilegesRequestBuilder> {
    public HasPrivilegesRequestBuilder(ElasticsearchClient client) {
        super(client, (Action)HasPrivilegesAction.INSTANCE, (ActionRequest)new HasPrivilegesRequest());
    }

    public HasPrivilegesRequestBuilder username(String username) {
        ((HasPrivilegesRequest)this.request).username(username);
        return this;
    }

    public HasPrivilegesRequestBuilder source(String username, BytesReference source, XContentType xContentType) throws IOException {
        RoleDescriptor role = RoleDescriptor.parsePrivilegesCheck(username + "/has_privileges", source, xContentType);
        ((HasPrivilegesRequest)this.request).username(username);
        ((HasPrivilegesRequest)this.request).indexPrivileges(role.getIndicesPrivileges());
        ((HasPrivilegesRequest)this.request).clusterPrivileges(role.getClusterPrivileges());
        return this;
    }
}

