/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson;

import java.io.File;
import java.io.IOException;
import java.util.logging.ConsoleHandler;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jvnet.hudson.Aix;
import org.jvnet.hudson.MemoryUsage;
import org.jvnet.hudson.ProcMemInfo;
import org.jvnet.hudson.Solaris;
import org.jvnet.hudson.Top;
import org.jvnet.hudson.Windows;

public abstract class MemoryMonitor {
    private static volatile MemoryMonitor INSTANCE = null;

    public abstract MemoryUsage monitor() throws IOException;

    public static MemoryMonitor get() throws IOException {
        if (INSTANCE == null) {
            INSTANCE = MemoryMonitor.obtain();
        }
        return INSTANCE;
    }

    private static MemoryMonitor obtain() throws IOException {
        if (File.pathSeparatorChar == ';') {
            return new Windows();
        }
        if (new File("/proc/meminfo").exists()) {
            return new ProcMemInfo();
        }
        String osName = System.getProperty("os.name");
        if ("AIX".equals(osName)) {
            Aix aix = new Aix();
            aix.monitor();
            return aix;
        }
        try {
            Top top = new Top();
            top.monitor();
            return top;
        }
        catch (Throwable _) {
            try {
                Solaris solaris = new Solaris();
                solaris.monitor();
                return solaris;
            }
            catch (Throwable throwable) {
                throw new IOException(String.format("No suitable implementation found: os.name=%s os.arch=%s sun.arch.data.model=%s", System.getProperty("os.name"), System.getProperty("os.arch"), System.getProperty("sun.arch.data.model")));
            }
        }
    }

    public static void main(String[] args) throws Exception {
        Logger l = Logger.getLogger(MemoryMonitor.class.getPackage().getName());
        l.setLevel(Level.FINE);
        ConsoleHandler h = new ConsoleHandler();
        h.setLevel(Level.FINE);
        l.addHandler(h);
        MemoryMonitor t = MemoryMonitor.get();
        System.out.println("implementation is " + t.getClass().getName());
        System.out.println(t.monitor());
    }
}

