/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.hudson;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import org.jvnet.hudson.MemoryMonitor;
import org.jvnet.hudson.MemoryUsage;

final class ProcMemInfo
extends MemoryMonitor {
    private static final String[] HEADERS = new String[]{"MemTotal:", "MemFree:", "SwapTotal:", "SwapFree:"};
    private static final Suffix[] SUFFIXES = new Suffix[]{new Suffix("KB", 1024L), new Suffix("MB", 0x100000L), new Suffix("GB", 0x40000000L)};
    private static final Suffix NONE = new Suffix("", 1L);

    ProcMemInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MemoryUsage monitor() throws IOException {
        BufferedReader r = new BufferedReader(new FileReader("/proc/meminfo"));
        try {
            String line;
            long[] values = new long[4];
            Arrays.fill(values, -1L);
            block5: while ((line = r.readLine()) != null) {
                for (int i = 0; i < HEADERS.length; ++i) {
                    if (!line.startsWith(HEADERS[i])) continue;
                    String s = line.substring(HEADERS[i].length()).trim();
                    Suffix suffix = Suffix.find(s);
                    s = s.substring(0, s.length() - suffix.name.length()).trim();
                    try {
                        values[i] = Long.parseLong(s) * suffix.multiplier;
                        continue block5;
                    }
                    catch (NumberFormatException e) {
                        throw new IOException("Failed to parse: '" + s + "' out of '" + line + "'");
                    }
                }
            }
            MemoryUsage memoryUsage = new MemoryUsage(values);
            return memoryUsage;
        }
        finally {
            r.close();
        }
    }

    private static class Suffix {
        final String name;
        final long multiplier;

        private Suffix(String name, long multiplier) {
            this.name = name;
            this.multiplier = multiplier;
        }

        static Suffix find(String line) {
            for (Suffix s : SUFFIXES) {
                if (!line.substring(line.length() - s.name.length()).equalsIgnoreCase(s.name)) continue;
                return s;
            }
            return NONE;
        }
    }
}

