/*
 * Decompiled with CFR 0.152.
 */
package org.jvnet.solaris.libzfs;

import org.jvnet.solaris.libzfs.ErrorCode;
import org.jvnet.solaris.libzfs.LibZFS;
import org.jvnet.solaris.libzfs.jna.libzfs;
import org.jvnet.solaris.libzfs.jna.libzfs_handle_t;

public class ZFSException
extends RuntimeException {
    private final ErrorCode code;

    ZFSException(LibZFS zfs) {
        this(zfs, null);
    }

    ZFSException(LibZFS zfs, String message) {
        super((message == null ? "" : message + " : ") + libzfs.LIBZFS.libzfs_error_description(zfs.getHandle()));
        libzfs_handle_t h = zfs.getHandle();
        this.code = ErrorCode.fromCode(libzfs.LIBZFS.libzfs_errno(h));
    }

    public ErrorCode getCode() {
        return this.code;
    }

    public String toString() {
        return super.toString() + " " + (Object)((Object)this.code);
    }
}

