/*
 * Decompiled with CFR 0.152.
 */
package hudson.remoting;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public abstract class ClassFilter {
    public static final String FILE_OVERRIDE_LOCATION_PROPERTY = "hudson.remoting.ClassFilter.DEFAULTS_OVERRIDE_LOCATION";
    private static final Logger LOGGER = Logger.getLogger(ClassFilter.class.getName());
    private static final String[] DEFAULT_PATTERNS = new String[]{"^com[.]google[.]inject[.].*", "^com[.]sun[.]jndi[.]rmi[.].*", "^java[.]rmi[.].*", "^org[.]apache[.]commons[.]beanutils[.].*", "^org[.]apache[.]commons[.]collections[.]functors[.].*", ".*org[.]apache[.]xalan.*", "^org[.]codehaus[.]groovy[.]runtime[.].*", "^org[.]hibernate[.].*", "^org[.]springframework[.](?!(\\p{Alnum}+[.])*\\p{Alnum}*Exception$).*", "^sun[.]rmi[.].*"};
    public static final ClassFilter DEFAULT = ClassFilter.createDefaultInstance();
    public static final ClassFilter NONE = new ClassFilter(){};

    protected boolean isBlacklisted(String name) {
        return false;
    }

    protected boolean isBlacklisted(Class c) {
        return false;
    }

    public final String check(String name) {
        if (this.isBlacklisted(name)) {
            throw new SecurityException("Rejected: " + name);
        }
        return name;
    }

    public final Class check(Class c) {
        if (this.isBlacklisted(c)) {
            throw new SecurityException("Rejected: " + c.getName());
        }
        return c;
    }

    static ClassFilter createDefaultInstance() {
        try {
            List<Pattern> patternOverride = ClassFilter.loadPatternOverride();
            if (patternOverride != null) {
                LOGGER.log(Level.FINE, "Using user specified overrides for class blacklisting");
                return new RegExpClassFilter(patternOverride);
            }
            LOGGER.log(Level.FINE, "Using default in built class blacklisting");
            return new RegExpClassFilter(DEFAULT_PATTERNS);
        }
        catch (Error e) {
            LOGGER.log(Level.SEVERE, "Failed to initialize the default class filter", e);
            throw e;
        }
    }

    @CheckForNull
    private static List<Pattern> loadPatternOverride() {
        String prop = System.getProperty(FILE_OVERRIDE_LOCATION_PROPERTY);
        if (prop == null) {
            return null;
        }
        LOGGER.log(Level.FINE, "Attempting to load user provided overrides for ClassFiltering from ''{0}''.", prop);
        File f = new File(prop);
        if (!f.exists() || !f.canRead()) {
            throw new Error("Could not load user provided overrides for ClassFiltering from as " + prop + " does not exist or is not readable.");
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(prop), Charset.defaultCharset()));
            ArrayList<Pattern> patterns = new ArrayList<Pattern>();
            String line = br.readLine();
            while (line != null) {
                try {
                    patterns.add(Pattern.compile(line));
                }
                catch (PatternSyntaxException pex) {
                    throw new Error("Error compiling blacklist expressions - '" + line + "' is not a valid regular expression.", pex);
                }
                line = br.readLine();
            }
            ArrayList<Pattern> arrayList = patterns;
            return arrayList;
        }
        catch (IOException ex) {
            throw new Error("Could not load user provided overrides for ClassFiltering from as " + prop + " does not exist or is not readable.", ex);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioEx) {
                    LOGGER.log(Level.WARNING, "Failed to cleanly close input stream", ioEx);
                }
            }
        }
    }

    private static final class RegExpClassFilter
    extends ClassFilter {
        private final List<Pattern> blacklistPatterns;

        public RegExpClassFilter(List<Pattern> blacklistPatterns) {
            this.blacklistPatterns = blacklistPatterns;
        }

        RegExpClassFilter(String[] patterns) {
            this.blacklistPatterns = new ArrayList<Pattern>(patterns.length);
            for (String pattern : patterns) {
                this.blacklistPatterns.add(Pattern.compile(pattern));
            }
        }

        @Override
        protected boolean isBlacklisted(String name) {
            for (Pattern p : this.blacklistPatterns) {
                if (!p.matcher(name).matches()) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            return this.blacklistPatterns.toString();
        }
    }
}

