/*
 * Decompiled with CFR 0.152.
 */
package hudson.cli;

import hudson.AbortException;
import hudson.Extension;
import hudson.cli.CLICommand;
import hudson.cli.Messages;
import hudson.model.Computer;
import hudson.util.EditDistance;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import jenkins.model.Jenkins;
import org.kohsuke.args4j.Argument;

@Extension
public class OnlineNodeCommand
extends CLICommand {
    @Argument(metaVar="NAME", usage="Agent name, or empty string for master", required=true, multiValued=true)
    private List<String> nodes;

    @Override
    public String getShortDescription() {
        return Messages.OnlineNodeCommand_ShortDescription();
    }

    @Override
    protected int run() throws Exception {
        boolean errorOccurred = false;
        Jenkins jenkins = Jenkins.getActiveInstance();
        HashSet<String> hs = new HashSet<String>(this.nodes);
        ArrayList<String> names = null;
        for (String node_s : hs) {
            Computer computer = null;
            try {
                computer = jenkins.getComputer(node_s);
                if (computer == null) {
                    String adv;
                    if (names == null) {
                        names = new ArrayList<String>();
                        for (Computer c : jenkins.getComputers()) {
                            if (c.getName().isEmpty()) continue;
                            names.add(c.getName());
                        }
                    }
                    throw new IllegalArgumentException((adv = EditDistance.findNearest(node_s, names)) == null ? hudson.model.Messages.Computer_NoSuchSlaveExistsWithoutAdvice(node_s) : hudson.model.Messages.Computer_NoSuchSlaveExists(node_s, adv));
                }
                computer.cliOnline();
            }
            catch (Exception e) {
                if (hs.size() == 1) {
                    throw e;
                }
                String errorMsg = node_s + ": " + e.getMessage();
                this.stderr.println(errorMsg);
                errorOccurred = true;
            }
        }
        if (errorOccurred) {
            throw new AbortException("Error occured while performing this command, see previous stderr output.");
        }
        return 0;
    }
}

