/*
 * Decompiled with CFR 0.152.
 */
package hudson.lifecycle;

import com.sun.akuma.JavaVMArguments;
import com.sun.jna.Native;
import com.sun.jna.StringArray;
import hudson.Platform;
import hudson.lifecycle.Lifecycle;
import hudson.lifecycle.RestartNotSupportedException;
import hudson.util.jna.GNUCLibrary;
import java.io.IOException;
import jenkins.model.Jenkins;

public class UnixLifecycle
extends Lifecycle {
    private JavaVMArguments args;
    private Throwable failedToObtainArgs;

    public UnixLifecycle() throws IOException {
        try {
            this.args = JavaVMArguments.current();
            this.args.remove((Object)"--daemon");
        }
        catch (UnsupportedOperationException e) {
            this.failedToObtainArgs = e;
        }
        catch (LinkageError e) {
            this.failedToObtainArgs = e;
        }
    }

    @Override
    public void restart() throws IOException, InterruptedException {
        Jenkins h = Jenkins.getInstanceOrNull();
        if (h != null) {
            h.cleanUp();
        }
        int sz = GNUCLibrary.LIBC.getdtablesize();
        for (int i = 3; i < sz; ++i) {
            int flags = GNUCLibrary.LIBC.fcntl(i, 1);
            if (flags < 0) continue;
            GNUCLibrary.LIBC.fcntl(i, 2, flags | 1);
        }
        String exe = (String)this.args.get(0);
        GNUCLibrary.LIBC.execvp(exe, new StringArray((String[])this.args.toArray((Object[])new String[this.args.size()])));
        throw new IOException("Failed to exec '" + exe + "' " + GNUCLibrary.LIBC.strerror(Native.getLastError()));
    }

    @Override
    public void verifyRestartable() throws RestartNotSupportedException {
        if (Platform.isDarwin() && !Platform.isSnowLeopardOrLater()) {
            throw new RestartNotSupportedException("Restart is not supported on Mac OS X");
        }
        if (this.args == null) {
            throw new RestartNotSupportedException("Failed to obtain the command line arguments of the process", this.failedToObtainArgs);
        }
    }
}

