/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.init.InitMilestone;
import hudson.init.Initializer;
import hudson.triggers.SafeTimerTask;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import jenkins.util.Timer;

public abstract class AperiodicWork
extends SafeTimerTask
implements ExtensionPoint {
    protected final Logger logger = Logger.getLogger(this.getClass().getName());
    private static final Random RANDOM = new Random();

    public abstract long getRecurrencePeriod();

    public abstract AperiodicWork getNewInstance();

    public long getInitialDelay() {
        long l = RANDOM.nextLong();
        if (l == Long.MIN_VALUE) {
            ++l;
        }
        return Math.abs(l) % this.getRecurrencePeriod();
    }

    @Override
    public final void doRun() throws Exception {
        this.doAperiodicRun();
        Timer.get().schedule(this.getNewInstance(), this.getRecurrencePeriod(), TimeUnit.MILLISECONDS);
    }

    @Initializer(after=InitMilestone.JOB_LOADED)
    public static void init() {
        for (AperiodicWork p : AperiodicWork.all()) {
            Timer.get().schedule(p, p.getInitialDelay(), TimeUnit.MILLISECONDS);
        }
    }

    protected abstract void doAperiodicRun();

    public static ExtensionList<AperiodicWork> all() {
        return ExtensionList.lookup(AperiodicWork.class);
    }
}

