/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Descriptor;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class DescriptorVisibilityFilter
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(DescriptorVisibilityFilter.class.getName());

    public abstract boolean filter(Object var1, Descriptor var2);

    public static ExtensionList<DescriptorVisibilityFilter> all() {
        return ExtensionList.lookup(DescriptorVisibilityFilter.class);
    }

    public static <T extends Descriptor> List<T> apply(Object context, Iterable<T> source) {
        ExtensionList<DescriptorVisibilityFilter> filters = DescriptorVisibilityFilter.all();
        ArrayList<Descriptor> r = new ArrayList<Descriptor>();
        block0: for (Descriptor d : source) {
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("Determining visibility of " + d + " in context " + context);
            }
            for (DescriptorVisibilityFilter f : filters) {
                if (LOGGER.isLoggable(Level.FINER)) {
                    LOGGER.finer("Querying " + f + " for visibility of " + d + " in " + context);
                }
                if (f.filter(context, d)) continue;
                if (!LOGGER.isLoggable(Level.CONFIG)) continue block0;
                LOGGER.config("Filter " + f + " hides " + d + " in context " + context);
                continue block0;
            }
            r.add(d);
        }
        return r;
    }
}

