/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Util;
import hudson.model.AbstractBuild;
import hudson.model.Fingerprint;
import hudson.model.Run;
import hudson.util.KeyedDataStorage;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jenkins.model.Jenkins;

public final class FingerprintMap
extends KeyedDataStorage<Fingerprint, FingerprintParams> {
    public boolean isReady() {
        return new File(Jenkins.getInstance().getRootDir(), "fingerprints").exists();
    }

    @Nonnull
    public Fingerprint getOrCreate(@CheckForNull AbstractBuild build, @Nonnull String fileName, @Nonnull byte[] md5sum) throws IOException {
        return this.getOrCreate(build, fileName, Util.toHexString(md5sum));
    }

    @Nonnull
    public Fingerprint getOrCreate(@CheckForNull AbstractBuild build, @Nonnull String fileName, @Nonnull String md5sum) throws IOException {
        return (Fingerprint)super.getOrCreate(md5sum, new FingerprintParams(build, fileName));
    }

    @Nonnull
    public Fingerprint getOrCreate(@CheckForNull Run build, @Nonnull String fileName, @Nonnull String md5sum) throws IOException {
        return (Fingerprint)super.getOrCreate(md5sum, new FingerprintParams(build, fileName));
    }

    @Override
    protected Fingerprint get(String md5sum, boolean createIfNotExist, FingerprintParams createParams) throws IOException {
        if (md5sum.length() != 32) {
            return null;
        }
        md5sum = md5sum.toLowerCase(Locale.ENGLISH);
        return (Fingerprint)super.get(md5sum, createIfNotExist, createParams);
    }

    private byte[] toByteArray(String md5sum) {
        byte[] data = new byte[16];
        for (int i = 0; i < md5sum.length(); i += 2) {
            data[i / 2] = (byte)Integer.parseInt(md5sum.substring(i, i + 2), 16);
        }
        return data;
    }

    @Override
    @Nonnull
    protected Fingerprint create(@Nonnull String md5sum, @Nonnull FingerprintParams createParams) throws IOException {
        return new Fingerprint(createParams.build, createParams.fileName, this.toByteArray(md5sum));
    }

    @Override
    @CheckForNull
    protected Fingerprint load(@Nonnull String key) throws IOException {
        return Fingerprint.load(this.toByteArray(key));
    }

    static class FingerprintParams {
        @CheckForNull
        final Run build;
        final String fileName;

        public FingerprintParams(@CheckForNull Run build, @Nonnull String fileName) {
            this.build = build;
            this.fileName = fileName;
            assert (fileName != null);
        }
    }
}

