/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Computer;
import hudson.model.Executor;
import java.io.IOException;
import jenkins.model.Jenkins;
import jenkins.model.queue.AsynchronousExecution;

public abstract class RestartListener
implements ExtensionPoint {
    public abstract boolean isReadyToRestart() throws IOException, InterruptedException;

    public void onRestart() {
    }

    public static ExtensionList<RestartListener> all() {
        return ExtensionList.lookup(RestartListener.class);
    }

    public static boolean isAllReady() throws IOException, InterruptedException {
        for (RestartListener listener : RestartListener.all()) {
            if (listener.isReadyToRestart()) continue;
            return false;
        }
        return true;
    }

    @Extension
    public static class Default
    extends RestartListener {
        @Override
        public boolean isReadyToRestart() throws IOException, InterruptedException {
            for (Computer c : Jenkins.getInstance().getComputers()) {
                if (!c.isOnline()) continue;
                for (Executor executor : c.getExecutors()) {
                    if (!Default.blocksRestart(executor)) continue;
                    return false;
                }
                for (Executor executor : c.getOneOffExecutors()) {
                    if (!Default.blocksRestart(executor)) continue;
                    return false;
                }
            }
            return true;
        }

        private static boolean blocksRestart(Executor e) {
            if (e.isBusy()) {
                AsynchronousExecution execution = e.getAsynchronousExecution();
                if (execution != null) {
                    return execution.blocksRestart();
                }
                return true;
            }
            return false;
        }
    }
}

