/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import com.thoughtworks.xstream.converters.SingleValueConverter;
import com.thoughtworks.xstream.converters.basic.AbstractSingleValueConverter;
import hudson.cli.declarative.OptionHandlerExtension;
import hudson.init.Initializer;
import hudson.model.BallColor;
import hudson.util.EditDistance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import org.apache.commons.beanutils.Converter;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.OptionDef;
import org.kohsuke.args4j.spi.OptionHandler;
import org.kohsuke.args4j.spi.Parameters;
import org.kohsuke.args4j.spi.Setter;
import org.kohsuke.stapler.Stapler;
import org.kohsuke.stapler.export.CustomExportedBean;

public final class Result
implements Serializable,
CustomExportedBean {
    @Nonnull
    public static final Result SUCCESS = new Result("SUCCESS", BallColor.BLUE, 0, true);
    @Nonnull
    public static final Result UNSTABLE = new Result("UNSTABLE", BallColor.YELLOW, 1, true);
    @Nonnull
    public static final Result FAILURE = new Result("FAILURE", BallColor.RED, 2, true);
    @Nonnull
    public static final Result NOT_BUILT = new Result("NOT_BUILT", BallColor.NOTBUILT, 3, false);
    @Nonnull
    public static final Result ABORTED = new Result("ABORTED", BallColor.ABORTED, 4, false);
    @Nonnull
    private final String name;
    @Nonnegative
    public final int ordinal;
    @Nonnull
    public final BallColor color;
    public final boolean completeBuild;
    private static final long serialVersionUID = 1L;
    private static final Result[] all = new Result[]{SUCCESS, UNSTABLE, FAILURE, NOT_BUILT, ABORTED};
    public static final SingleValueConverter conv = new AbstractSingleValueConverter(){

        public boolean canConvert(Class clazz) {
            return clazz == Result.class;
        }

        public Object fromString(String s) {
            return Result.fromString(s);
        }
    };

    private Result(@Nonnull String name, @Nonnull BallColor color, @Nonnegative int ordinal, boolean complete) {
        this.name = name;
        this.color = color;
        this.ordinal = ordinal;
        this.completeBuild = complete;
    }

    @Nonnull
    public Result combine(@Nonnull Result that) {
        if (this.ordinal < that.ordinal) {
            return that;
        }
        return this;
    }

    public boolean isWorseThan(@Nonnull Result that) {
        return this.ordinal > that.ordinal;
    }

    public boolean isWorseOrEqualTo(@Nonnull Result that) {
        return this.ordinal >= that.ordinal;
    }

    public boolean isBetterThan(@Nonnull Result that) {
        return this.ordinal < that.ordinal;
    }

    public boolean isBetterOrEqualTo(@Nonnull Result that) {
        return this.ordinal <= that.ordinal;
    }

    public boolean isCompleteBuild() {
        return this.completeBuild;
    }

    @Nonnull
    public String toString() {
        return this.name;
    }

    @Nonnull
    public String toExportedObject() {
        return this.name;
    }

    @Nonnull
    public static Result fromString(@Nonnull String s) {
        for (Result r : all) {
            if (!s.equalsIgnoreCase(r.name)) continue;
            return r;
        }
        return FAILURE;
    }

    @Nonnull
    private static List<String> getNames() {
        ArrayList<String> l = new ArrayList<String>();
        for (Result r : all) {
            l.add(r.name);
        }
        return l;
    }

    private Object readResolve() {
        for (Result r : all) {
            if (this.ordinal != r.ordinal) continue;
            return r;
        }
        return FAILURE;
    }

    @Initializer
    public static void init() {
        Stapler.CONVERT_UTILS.register(new Converter(){

            public Object convert(Class type, Object value) {
                return Result.fromString(value.toString());
            }
        }, Result.class);
    }

    @OptionHandlerExtension
    public static final class OptionHandlerImpl
    extends OptionHandler<Result> {
        public OptionHandlerImpl(CmdLineParser parser, OptionDef option, Setter<? super Result> setter) {
            super(parser, option, setter);
        }

        @Override
        public int parseArguments(Parameters params) throws CmdLineException {
            String param = params.getParameter(0);
            Result v = Result.fromString(param.replace('-', '_'));
            if (v == null) {
                throw new CmdLineException(this.owner, "No such status '" + param + "'. Did you mean " + EditDistance.findNearest(param.replace('-', '_').toUpperCase(), Result.getNames()));
            }
            this.setter.addValue(v);
            return 1;
        }

        @Override
        public String getDefaultMetaVariable() {
            return "STATUS";
        }
    }
}

