/*
 * Decompiled with CFR 0.152.
 */
package hudson.model.listeners;

import com.google.common.base.Function;
import hudson.ExtensionList;
import hudson.ExtensionPoint;
import hudson.model.Item;
import hudson.model.ItemGroup;
import hudson.model.Items;
import hudson.security.ACL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.security.NotReallyRoleSensitiveCallable;

public class ItemListener
implements ExtensionPoint {
    private static final Logger LOGGER = Logger.getLogger(ItemListener.class.getName());

    public void onCreated(Item item) {
    }

    public void onCopied(Item src, Item item) {
        this.onCreated(item);
    }

    public void onLoaded() {
    }

    public void onDeleted(Item item) {
    }

    public void onRenamed(Item item, String oldName, String newName) {
    }

    public void onLocationChanged(Item item, String oldFullName, String newFullName) {
    }

    public void onUpdated(Item item) {
    }

    public void onBeforeShutdown() {
    }

    @Deprecated
    public void register() {
        ItemListener.all().add(this);
    }

    public static ExtensionList<ItemListener> all() {
        return ExtensionList.lookup(ItemListener.class);
    }

    private static void forAll(Function<ItemListener, Void> consumer) {
        for (ItemListener l : ItemListener.all()) {
            try {
                consumer.apply((Object)l);
            }
            catch (RuntimeException x) {
                LOGGER.log(Level.WARNING, "failed to send event to listener of " + l.getClass(), x);
            }
        }
    }

    public static void fireOnCopied(final Item src, final Item result) {
        ItemListener.forAll(new Function<ItemListener, Void>(){

            public Void apply(ItemListener l) {
                l.onCopied(src, result);
                return null;
            }
        });
    }

    public static void fireOnCreated(final Item item) {
        ItemListener.forAll(new Function<ItemListener, Void>(){

            public Void apply(ItemListener l) {
                l.onCreated(item);
                return null;
            }
        });
    }

    public static void fireOnUpdated(final Item item) {
        ItemListener.forAll(new Function<ItemListener, Void>(){

            public Void apply(ItemListener l) {
                l.onUpdated(item);
                return null;
            }
        });
    }

    public static void fireOnDeleted(final Item item) {
        ItemListener.forAll(new Function<ItemListener, Void>(){

            public Void apply(ItemListener l) {
                l.onDeleted(item);
                return null;
            }
        });
    }

    public static void fireLocationChange(final Item rootItem, final String oldFullName) {
        String prefix = rootItem.getParent().getFullName();
        if (!prefix.isEmpty()) {
            prefix = prefix + '/';
        }
        final String newFullName = rootItem.getFullName();
        assert (newFullName.startsWith(prefix));
        int prefixS = prefix.length();
        if (oldFullName.startsWith(prefix) && oldFullName.indexOf(47, prefixS) == -1) {
            final String oldName = oldFullName.substring(prefixS);
            final String newName = rootItem.getName();
            assert (newName.equals(newFullName.substring(prefixS)));
            ItemListener.forAll(new Function<ItemListener, Void>(){

                public Void apply(ItemListener l) {
                    l.onRenamed(rootItem, oldName, newName);
                    return null;
                }
            });
        }
        ItemListener.forAll(new Function<ItemListener, Void>(){

            public Void apply(ItemListener l) {
                l.onLocationChanged(rootItem, oldFullName, newFullName);
                return null;
            }
        });
        if (rootItem instanceof ItemGroup) {
            for (final Item child : ACL.impersonate(ACL.SYSTEM, new NotReallyRoleSensitiveCallable<List<Item>, RuntimeException>(){

                @Override
                public List<Item> call() {
                    return Items.getAllItems((ItemGroup)((Object)rootItem), Item.class);
                }
            })) {
                final String childNew = child.getFullName();
                assert (childNew.startsWith(newFullName));
                assert (childNew.charAt(newFullName.length()) == '/');
                final String childOld = oldFullName + childNew.substring(newFullName.length());
                ItemListener.forAll(new Function<ItemListener, Void>(){

                    public Void apply(ItemListener l) {
                        l.onLocationChanged(child, childOld, childNew);
                        return null;
                    }
                });
            }
        }
    }
}

