/*
 * Decompiled with CFR 0.152.
 */
package hudson.os;

import com.sun.solaris.EmbeddedSu;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.model.Computer;
import hudson.model.TaskListener;
import hudson.remoting.Callable;
import hudson.remoting.Launcher;
import hudson.remoting.LocalChannel;
import hudson.remoting.VirtualChannel;
import hudson.remoting.Which;
import hudson.slaves.Channels;
import hudson.util.ArgumentListBuilder;
import hudson.util.jna.GNUCLibrary;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Collections;

public abstract class SU {
    private SU() {
    }

    public static VirtualChannel start(final TaskListener listener, final String rootUsername, final String rootPassword) throws IOException, InterruptedException {
        if (File.pathSeparatorChar == ';') {
            return SU.newLocalChannel();
        }
        String os = Util.fixNull(System.getProperty("os.name"));
        if (os.equals("Linux")) {
            return new UnixSu(){

                @Override
                protected String sudoExe() {
                    return "sudo";
                }

                @Override
                protected Process sudoWithPass(ArgumentListBuilder args) throws IOException {
                    args.prepend(this.sudoExe(), "-S");
                    listener.getLogger().println("$ " + Util.join(args.toList(), " "));
                    ProcessBuilder pb = new ProcessBuilder(args.toCommandArray());
                    Process p = pb.start();
                    PrintStream ps = new PrintStream(p.getOutputStream());
                    ps.println(rootPassword);
                    ps.println(rootPassword);
                    ps.println(rootPassword);
                    return p;
                }
            }.start(listener, rootPassword);
        }
        if (os.equals("SunOS")) {
            return new UnixSu(){

                @Override
                protected String sudoExe() {
                    return "/usr/bin/pfexec";
                }

                @Override
                protected Process sudoWithPass(ArgumentListBuilder args) throws IOException {
                    listener.getLogger().println("Running with embedded_su");
                    ProcessBuilder pb = new ProcessBuilder(args.prepend(this.sudoExe()).toCommandArray());
                    return EmbeddedSu.startWithSu((String)rootUsername, (String)rootPassword, (ProcessBuilder)pb);
                }
            }.start(listener, rootUsername == null ? null : rootPassword);
        }
        return SU.newLocalChannel();
    }

    private static LocalChannel newLocalChannel() {
        return FilePath.localChannel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <V, T extends Throwable> V execute(TaskListener listener, String rootUsername, String rootPassword, Callable<V, T> closure) throws T, IOException, InterruptedException {
        VirtualChannel ch = SU.start(listener, rootUsername, rootPassword);
        try {
            V v = ch.call(closure);
            return v;
        }
        finally {
            ch.close();
            ch.join(3000L);
        }
    }

    private static abstract class UnixSu {
        private UnixSu() {
        }

        protected abstract String sudoExe();

        protected abstract Process sudoWithPass(ArgumentListBuilder var1) throws IOException;

        VirtualChannel start(TaskListener listener, String rootPassword) throws IOException, InterruptedException {
            int uid = GNUCLibrary.LIBC.geteuid();
            if (uid == 0) {
                return SU.newLocalChannel();
            }
            String javaExe = System.getProperty("java.home") + "/bin/java";
            File slaveJar = Which.jarFile(Launcher.class);
            ArgumentListBuilder args = new ArgumentListBuilder().add(javaExe);
            if (slaveJar.isFile()) {
                args.add("-jar").add(slaveJar);
            } else {
                args.add("-cp").add(slaveJar).add(Launcher.class.getName());
            }
            if (rootPassword == null) {
                return new Launcher.LocalLauncher(listener).launchChannel(args.prepend(this.sudoExe()).toCommandArray(), listener.getLogger(), null, Collections.emptyMap());
            }
            Process proc = this.sudoWithPass(args);
            return Channels.forProcess(args.toStringWithQuote(), Computer.threadPoolForRemoting, proc, listener.getLogger());
        }
    }
}

